#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "KernelSmoothing.h"

int main (int argc, char* argv[]) {
	srand (time(0));
	//  COM (   )
	CoInitialize(0);

	//   
	const int L = 100;

	//      
	CmaIndex sz(3);
	CmaMatrix Data  (MA_DOUBLE, sz[L][2], L"KSTest.Data", 1);
	CmaMatrix Weight(MA_DOUBLE, sz[L], L"KSTest.Weight", 1);
	CmaMatrix Target(MA_DOUBLE, sz[L], L"KSTest.Target", 1);
	//      ,  , 
	//CmaMatrix Data  (MA_DOUBLE, sz[L][2]);  

	//   -      
	int i;
	for (i=0; i<L; i++) {
		double p1 = rand() / double(RAND_MAX);
		double p2 = rand() / double(RAND_MAX);
		//   (   = 0.5)
		int y = rand() % 2;   
		//    y
		switch (y) {
			case 0:  
				Data[i][0] = -log (1/p1-1); 
				Data[i][1] = -log (1/p2-1); 
				break;
			case 1:
				Data[i][0] = 1 + 0.2 * -log (1/p1-1); 
				Data[i][1] = 1 + 0.2 * -log (1/p2-1); 
				break;
		}
		//    i- 
		Weight[i] = 1;
		Target[i] = y;
	}

	//    
	CKernelSmoothing A;
	A.Kernel = KGauss;
	A.h = 0.15;
	A.Train (Data, Weight, Target);

	//  
	double dx = 0.05;
	double dy = 0.05;
	FILE* chd = fopen ("KernelSmooth.chd","w");
	fprintf (chd, 
		"#Include sty.black-white.chd\n"
		"#Slide.Style stySlide\n"
		"#Panel.Style styPanel\n"
		"#NewData x y z\n"
		"#Let real x1 = x-%g/2\n"
		"#Let real x2 = x+%g/2\n"
		"#Let real y1 = y-%g/2\n"
		"#Let real y2 = y+%g/2\n"
		"#Series X=x1 Y=y1 BX=x2 BY=y2 C=1 G=2 I=z U=40\n",
		dx,dx,dy,dy
	);
	CmaMatrix X (MA_DOUBLE, sz[1][2]);
	CmaMatrix Y (MA_DOUBLE, sz[1]);
	for (double x=-2; x<=4; x+=dx) {
		for (double y=-2; y<=4; y+=dy) {
			//if ((x-1)*(x-1)+(y-1)*(y-1)>9) continue;
			X[0][0] = x;
			X[0][1] = y;
			A.Test (X,Y);
			fprintf (chd, "%g\t%g\t%g\n", x, y, double(Y[0]));
		}
	}
	fprintf (chd, 
		"#NewData xtr ytr class\n"
		"#Series X=xtr Y=ytr C=class\n"
	);
	for (i=0; i<L; i++) {
		fprintf (chd, "%g\t%g\t%d\n", 
			double(Data[i][0]), 
			double(Data[i][1]), 
			1+int(Target[i]));
	}
	fclose (chd);

	printf ("Press [Enter] ... ");
	getchar ();
	return 0;
}

