#ifndef KERNEL_SMOOTHING_H
#define KERNEL_SMOOTHING_H

#include <math.h>
#include "Learner.h"   // -

// =====================================================================
//  --  !
// =====================================================================

//   -   (     1) 
typedef double (*FSoothingKernel) (double r);

//   ( )
double KSimple (double r);

//   (   =>      )
double KGauss (double r);

//   ( ,  -)
double KEpanechnikov (double r);

//   (   )
double KQuadratic (double r);

// =====================================================================
//      
// =====================================================================
class CKernelSmoothing : public CLearner {
public:
	CKernelSmoothing ();
	~CKernelSmoothing ();

	double h;  //   
	FSoothingKernel Kernel;  //  
	
	//  
	int Train (
		CmaMatrix &Features, //   * 
		CmaMatrix &Weight,   //   * {}
		CmaMatrix &Target    //   * {}
	);
	
	//  
	int Test (
		CmaMatrix &Features, //   * 
		CmaMatrix &Result    //   * {}
	);

private:
	//   
	CmaMatrix TrainFeatures;
	CmaMatrix TrainWeight;
	CmaMatrix TrainTarget;
};

// =====================================================================
//   M>=2     
//    -
// =====================================================================

#endif
