#include "KernelSmoothing.h"

inline double sq (double z) {
	return z*z;
}

// =====================================================================
//  --  !
// =====================================================================

//   ( )
double KSimple (double r) {
	return fabs(r)<1 ? 0.5 : 0;
}

//   (   =>      )
double KGauss (double r){
	const double PI = 2*asin(1);
	return exp(-r*r/2) / sqrt(2*PI);
}

//   ( ,   )
double KEpanechnikov (double r) {
	return fabs(r)<1 ? 0.75 * (1-r*r) : 0;
}

//   (  )
double KQuadratic (double r) {
	return fabs(r)<1 ? 0.9375 * (1-r*r) * (1-r*r) : 0;
}

// =====================================================================
//      
// =====================================================================
CKernelSmoothing::CKernelSmoothing () {
	Kernel = KQuadratic;
	h = 1.0;
}

CKernelSmoothing::~CKernelSmoothing () {
} 

//  
int CKernelSmoothing::Train (
	CmaMatrix &Features, //   * 
	CmaMatrix &Weight,   //   * {}
	CmaMatrix &Target    //   * {}
) {
	TrainFeatures = Features;
	TrainWeight = Weight;
	TrainTarget = Target;
	return 0;	
}

//  
int CKernelSmoothing::Test (
	CmaMatrix &Features, //   * 
	CmaMatrix &Result    //   * {}
) {
	int k = Features.Size(0);  //   
	int L = TrainFeatures.Size(0);  //   
	int n = TrainFeatures.Size(1);  //  
	//  -,       
	for (int i=0; i<k; i++) {
		double sumWY = 0.0;
		double sumW = 0.0;
		for (int iTrain=0; iTrain<L; iTrain++) {
			//     Test[i]  Train[iTrain]
			double RR = 0.0;
			for (int j=0; j<n; j++)
				RR += sq (TrainFeatures[iTrain][j] - Features[i][j]);
			//    
			double w = TrainWeight[iTrain] * Kernel (sqrt(RR)/h);
			//       -
			sumWY += w * TrainTarget[iTrain];
			sumW += w;
		}
		//    i-  
		Result[i] = double (sumW>0 ? sumWY/sumW : 0);
	}
	return 0;	
}
