#include<stdio.h>
#include<stdlib.h>
#include<string.h> 
#include<time.h>

// ,     
typedef char FileDrive[_MAX_DRIVE];
typedef char FileDir[_MAX_DIR];
typedef char FileName[_MAX_FNAME];
typedef char FileExt[_MAX_EXT];
typedef char FileFullname[_MAX_DRIVE+_MAX_DIR+_MAX_FNAME+_MAX_EXT];
#define SPLIT_PATH _splitpath
#define MERGE_PATH _makepath

//    DOS-Win-UNIX

typedef enum {LF_KEEP, LF_UNIX, LF_DOS} LineFeed;
typedef enum {LB_KEEP, LB_TABS, LB_BLANKS} LeadBlanks;

typedef struct { // 
	char key; //  
	char* chars; // 
} Coding;

//  .    ,   
//     - ,   .
// ,   ,  1:1
static Coding TAB[] = {
	{'W', " ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890Ũ߹.,:;!?`\'\"=+*-\\|/<>()[]{}~@#$%^&_"},
	{'D', " ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890񦧨.,:;!?`\'\"=+*-\\|/<>()[]{}~@#$%^&_"},
	{'K', " ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ţ.,:;!?`\'\"=+*-\\|/<>()[]{}~@#$%^&_"},
	{'I', " ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ﰱ"},
	{'\0',0}
};

//      
static unsigned char SET[256];

//     ,   key
char* find_coding (char key) {
	int i;
	for (i=0; TAB[i].key; i++)
		if (TAB[i].key==key) return TAB[i].chars;
	return (char*)0;
}

//   
void debug_SET () {
	unsigned int i, j;
	for (i=0; i<16; i++) {
		printf ("%3d : ", i*16);
		for (j=0; j<16; j++)
			printf ("%4d", SET[i*16+j]);
		printf ("\n");
	}
}

//   
void puts_encode (char* str) {
	static buf[1000];
	unsigned char *s, ch;
	for (s=str; *s; s++) {
		ch = SET[*s];
		fwrite (&ch, 1, 1, stdout); 
	}
	ch = 10;
	fwrite (&ch, 1, 1, stdout); 
}

void usage () {
	puts ( "FILTRA is a text FILes TRAnslation program.    (c) K.Vorontsov"); 
	puts ( "Usage:"); 
	puts ( "    filtra [options] [InFile] [options] [OutFile] [options]"); 
	puts ( "Options:"); 
	puts ( "    -h|-?    - Russian help, may be combined with -XY or -$ option"); 
	puts ( "    -f       - translate InFile to itself, OutFile can be omited");
	puts ( "    -d       - DOS style eoln=CR+LF"); 
	puts ( "    -u       - Unix style eoln=LF"); 
	puts ( "    -t<ntab> - Replace each <ntab> leading blanks by tabulation"); 
	puts ( "    -b<ntab> - Replace each leading tabulation by <ntab> blanks"); 
	puts ( "    -XY      - Translate file from <X> into <Y> coding, where <X>, <Y>:"); 
	puts ( "                 W - Windows ANSI"); //   
	puts ( "                 D - DOS (866 code page)"); 
	puts ( "                 K - KOI-8"); 
	puts ( "                 I - ISO 8859-5 (russian UNIX)"); 
	puts ( "               (no coding if omited)"); 
	puts ( "    -$<set>  - Coding table file <set>, no coding if omited"); 
	puts ( "    -w<sec>  - If one of file can not be opened, wait <sec> seconds"); 
	puts ( "Argiments:"); 
	puts ( "    InFile   - input file, stdin if omited"); 
	puts ( "    OutFile  - output file, stdout if omited"); 
	puts ( "    Both may contain wildcard * to substitute disk, path, name or ext."); 
	puts ( "Example:"); 
	puts ( "    filtra -d -t4 -WD test.cpp ../src-cc/*.cc"); 
	exit(0);
}

void usage_rus () {
	puts_encode ( "FILTRA -   .    (c) ."); 
	puts_encode ( ":"); 
	puts_encode ( "    filtra [] [] [] [] []"); 
	puts_encode ( ":"); 
	puts_encode ( "    -d       - DOS-   eoln=CR+LF"); 
	puts_encode ( "    -f       -    ,   "); 
	puts_encode ( "    -u       - Unix-   eoln=LF"); 
	puts_encode ( "    -t<ntab> -   <ntab>   "); 
	puts_encode ( "    -b<ntab> -     <ntab> "); 
	puts_encode ( "    -<X><Y>  -   <X>  <Y>,  <X>, <Y>  :"); 
	puts_encode ( "                 W - Windows ANSI"); //   
	puts_encode ( "                 D - DOS (866  )"); 
	puts_encode ( "                 K - KOI-8"); 
	puts_encode ( "                 I - ISO 8859-5 ( UNIX)"); 
	puts_encode ( "               ( ,   )"); 
	puts_encode ( "    -$<set>  -     <set>"); 
	puts_encode ( "    -w<sec>  -    ,  <sec> "); 
	puts_encode ( ":"); 
	puts_encode ( "     -  , stdin  "); 
	puts_encode ( "      -  , stdout  "); 
	puts_encode ( "     *     //  ."); 
	puts_encode ( ":"); 
	puts_encode ( "    filtra -d -t4 -WD test.cpp ../src-cc/*.cc"); 
	exit(0);
}

void error (char* mess) {
	printf ("ERROR! %s\n", mess);
	exit(1);
}

void remove_last (char* s, char ch) {
	int len;
	if (s && *s && s[len=strlen(s)-1]==ch) s[len] = '\0';
}

//    STR  len ,    pos,  str
void strsubst (char* STR, char* str, int pos, int len) {
	int L, i;
	L = strlen(str)-len;
	if (L>0) //   
		for (i=strlen(STR); i>=pos+len; i--) STR[i+L]=STR[i];
	if (L<0) //   
		for (i=pos+len; STR[i+L]=STR[i]; i++);
	for (i=0; str[i]; i++) STR[pos+i]=str[i];
}

void remove_wilds (char* s1, char* s2) {
	char *w1, *w2;
	w1 = strchr (s1, '*');
	w2 = strchr (s2, '*');
	if (w1 && w2) error ("Can not resolve file path, name or extention");
	if (w1) strsubst (s1, s2, w1-s1, 1);
	if (w2) strsubst (s2, s1, w2-s2, 1);
	//printf ("Wilds removed: %s -- %s\n", s1, s2);
}

/*
void remove_wilds (char* s1, char* s2) {
	int w1 = *s1=='*' && *(s1+1)=='\0';
	int w2 = *s2=='*' && *(s2+1)=='\0';
	if (w1 && w2) error ("Can not resolve file path, name or extention");
	if (w1) strcpy (s1, s2);
	if (w2) strcpy (s2, s1);
}*/

int main (int argc, char *argv[], char *envp[]) {
	FILE *S, *R, *W; 
	unsigned char *x, *y;
	char *Rfullname, *Wfullname, *rext, *wext;
	unsigned char ch, c13, c10, c9, cb; 
	int i, a, n_tab, is_lead, lead_count, is_usage_rus, is_same_file;
	double waitsec;
	clock_t clock_begin;
	FileDrive Rdrive, Wdrive;
	FileDir Rdir, Wdir;
	FileName Rname, Wname;
	FileExt Rext, Wext;
	
	//   :
	LineFeed linefeed_mode = LF_KEEP; //    EOLn  
	LeadBlanks leaders_mode = LB_KEEP; //      
	Rfullname = 0; //    
	Wfullname = 0; //    
	waitsec = 10.0; //     
	for (i=0; i<256; i++) SET[i] = i;  //  
	
	//  :
	is_lead = 1; //   :  
	lead_count = 0; //   
	c13=13; c10=10; c9=9; cb=' '; // 
	is_usage_rus = 0;
	is_same_file = 0;

	//     :
	if (argc<2) usage();

	//   :
	for (a=1; a<argc; a++) {
		if (argv[a][0] != '-') {
			if (Rfullname==0) Rfullname = argv[a]; 
			else if (Wfullname==0)Wfullname = argv[a]; 
		}
		else switch (argv[a][1]) {
			case 'h': 
			case '?': 
				is_usage_rus = 1;
				break;
			case 'd': 
				linefeed_mode = LF_DOS;
				break;
			case 'u': 
				linefeed_mode = LF_UNIX;
				break;
			case 'f': 
				is_same_file = 1;
				break;
			case '$':
				S = fopen (argv[a]+2, "rb"); 
				SET[0] = 0; 
				fread (SET+1, 255, 1, S); 
				fclose (S);
				break;
			case 't':
				leaders_mode = LB_TABS;
				n_tab = atoi (argv[a]+2);
				break;
			case 'b':
				leaders_mode = LB_BLANKS;
				n_tab = atoi (argv[a]+2);
				break;
			case 'w':
				waitsec = atof (argv[a]+2);
				break;
			default:
				if (argv[a][1]=='\0' || argv[a][2]=='\0')
					break;
				x = find_coding (argv[a][1]);
				y = find_coding (argv[a][2]);
				if (x==0) error ("Unknown input coding");
				if (y==0) error ("Unknown output coding");
				while (*x && *y)
					SET[*x++] = *y++;
				break;
		}
	}

	if (is_usage_rus) 
		usage_rus();

	if (is_same_file) {
		Wfullname = "_filtra_.tmp";
	}
	
	//   (    )
	if (Rfullname && Wfullname) {
		SPLIT_PATH (Rfullname, Rdrive, Rdir, Rname, Rext);
		SPLIT_PATH (Wfullname, Wdrive, Wdir, Wname, Wext);
		remove_last (Rdrive, ':');
		remove_last (Wdrive, ':');
		remove_last (Rdir, '\\'); remove_last (Rdir, '/');
		remove_last (Wdir, '\\'); remove_last (Wdir, '/');
		rext = (Rext && *Rext=='.') ? Rext+1 : Rext;
		wext = (Wext && *Wext=='.') ? Wext+1 : Wext;
		remove_wilds (Rdrive, Wdrive);
		remove_wilds (Rdir, Wdir);
		remove_wilds (Rname, Wname);
		remove_wilds (rext, wext);
		MERGE_PATH (Rfullname, Rdrive, Rdir, Rname, rext);
		MERGE_PATH (Wfullname, Wdrive, Wdir, Wname, wext);
	}
	R = stdin; 
	W = stdout; 

	clock_begin = clock();
	if (Rfullname) do 
		{R = fopen (Rfullname, "rb");}
	while (R==0 && (clock()-clock_begin)<waitsec*CLOCKS_PER_SEC);
	if (R==0) error ("Can not open input file");

	clock_begin = clock();
	if (Wfullname) do 
		{W = fopen (Wfullname, "wb");}
	while (W==0 && (clock()-clock_begin)<waitsec*CLOCKS_PER_SEC);
	if (W==0) error ("Can not open output file");
	//if (R==0) { printf ("Can not open input file \"%s\"\n", Rfullname); exit(1); }
	//if (W==0) { printf ("Can not open output file \"%s\"\n", Wfullname); exit(1); }

	//  :
	while (fread (&ch, 1, 1, R)) {
		ch = SET[ch];
		if (leaders_mode==LB_TABS && ch==cb && n_tab>0 && is_lead) {
			lead_count++;
			if (lead_count==n_tab) {
				fwrite (&c9, 1, 1, W); 
				lead_count = 0;
			}
		}
		else if (leaders_mode==LB_BLANKS && ch==c9 && n_tab>0 && is_lead) {
			for (i=0; i<n_tab; i++)
				fwrite (&cb, 1, 1, W); 
		}
		else if (ch==c13 && linefeed_mode!=LF_KEEP) 
			continue;
		else if (ch==c10) { 
			if (linefeed_mode==LF_DOS) fwrite (&c13, 1, 1, W); 
			is_lead = 1;
			lead_count = 0;
			fwrite (&ch, 1, 1, W); 
			continue;
		}
		else
			fwrite (&ch, 1, 1, W); 
		is_lead = is_lead && (ch==cb || ch==c9);
	}

	//  ,   :
	if (W!=stdout) fclose (W);
	if (R!=stdin)  fclose (R);
	if (is_same_file) {
		remove (Rfullname);
		rename (Wfullname, Rfullname);
	}

	return 0;
}
