UNIT Serv;

     {  Some usefull functions are defined here.
          Trun        - deletes all blanks in the string.
          TrunUp      - deletes all blanks and upcases all chars.
          Token       - splits lexical construction as <Token><Value>.
          Str         - gives the best representation of real as string.
          Val         - inverse function for Str.
          CalcGrid    - calculates parameters of grid (for visualization).
          Ran         - gives random real number between a and b.
     }
     INTERFACE

function  UpCase      (ch: char): char;
procedure UpStr       (var Str: String);
procedure Trun        (var Str: String);
procedure TrunUp      (var Str: String);
procedure TrunL       (var Str: String);
procedure TrunR       (var Str: String);
procedure TrunLR      (var Str: String);
procedure Concat      (var Str: String; Add: String);
function  Token       (var Buf: String; Tok: String): boolean;
function  ScanToken   (Str,Delim:String; var Tok:String; var Pos:word):boolean;
function  Str         (r:real)    : string;
function  StrDecim    (r:real; Decim: integer): string;
function  Val         (s:string)  : real;
function  RealDiv     (x, y, If_y_Zero: real): real;
function  DoubDiv     (x, y, If_y_Zero: double): double;
procedure CalcGrid    (a, b: real; VAR N, sgn: integer; VAR a0, H: real);
function  Ran         (a, b: real): real;

     IMPLEMENTATION

function  UpCase (ch: char): char;
          begin
          if ord(ch)<$80
            then UpCase:= System.UpCase(ch)
          else if ($A0<=ord(ch)) and (ord(ch)<=$AF)
            then UpCase:= chr(ord(ch)-$20)
          else if ($E0<=ord(ch)) and (ord(ch)<=$EF)
            then UpCase:= chr(ord(ch)-$50)
          else if ch=''
            then UpCase:= ''
          else UpCase:=ch;
          end;

procedure UpStr (var Str: String);
          var i: integer;
          begin
          for i:=1 to Length (Str) do Str[i]:= UpCase(Str[i]);
          end;

procedure Trun (var Str: String);
          var i,j: integer;
          begin
          j:=0; for i:=1 to Length (Str) do
            if not (Str[i] in [' ',#9,#0]) then begin
              Inc(j); Str[j]:=Str[i];
              end;
          Str[0]:= Chr(j);
          end;

procedure TrunUp (var Str: String);
          var i,j: integer;
          begin
          j:=0; for i:=1 to Length (Str) do
            if not (Str[i] in [' ',#9,#0]) then begin
              Inc(j); Str[j]:= UpCase(Str[i]);
              end;
          Str[0]:= Chr(j);
          end;

procedure TrunL (var Str: String);
          var i, k: integer;
          begin
          k:=1;
          while (k<=length(Str)) and (Str[k] in [' ',#9]) do Inc(k);
          for i:=k to length (Str) do Str[i-k+1]:= Str[i];
          Dec (Str[0], k-1);
          end;

procedure TrunR (var Str: String);
          var i, k: integer;
          begin
          k:=length(Str);
          while (k>0) and (Str[k] in [' ',#9]) do Dec(k);
          Str[0]:= chr(k);
          end;

procedure TrunLR (var Str: String);
          begin
          TrunR(Str); TrunL(Str);
          end;

procedure Concat (var Str: String; Add: String);
          var i, j: integer;
          begin
          i:=0; j:= length (Str);
          while (j<255) and (i<length(Add)) do begin
            Inc(i); Inc(j);
            Str[j]:= Add[i];
            end;
          Str[0]:= chr(j);
          end;

function  Token (var Buf: String; Tok: String): boolean;
          var k: integer;
          begin
          TrunUp (Buf);
          TrunUp (Tok);
          k:= pos (Tok, Buf); Token:=(k=1);
          if k=1 then Delete (Buf, 1, Length(Tok));
          end;

function  ScanToken (Str,Delim:String; var Tok:String; var Pos:word):boolean;
          var  k: integer;

          function  Delimeter (var Str,Delim: String; Pos: word): boolean;
                    var i: integer;
                    begin
                    i:=1; Delimeter:= FALSE;
                    while i<=length(Delim) do begin
                      if Str[Pos]<>Delim[i] then exit;
                      Inc(i); Inc(Pos);
                      end;
                    Delimeter:= TRUE;
                    end;
          begin
          k:=0; Tok[0]:=#0;
          ScanToken:= FALSE;
          if (Pos>length(Str)) then exit;
          ScanToken:= TRUE;
          while (Pos<=length(Str)) and not Delimeter(Str,Delim,Pos) do begin
            Inc(k);
            Tok[k]:= Str[Pos];
            Inc(Pos);
            end;
          Inc (Pos, length(Delim));
          Tok[0]:= chr (k);
          end;

function  Str (r:real): string;
          var m,c,s1,s2,zeros : string[30];
             k,n : integer;
          begin
          if r=0 then str:='0' else
            begin
            if r<0.0 then c:='-' else c:='';
            r:= abs(r); k:=0;
            while r>=1.0 do  begin r:=r*0.1;  Inc(k) end;
            while r< 0.1-1e-10 do  begin r:=r*10.;  Dec(k) end;
            System.Str ( Round (r*1e9),m );
            if length (m) = 10 then Inc(k);
            while  (length(m)>0) and (m[length(m)]='0') do Dec (m[0]);
            n:=length(m);
            System.Str ( k,s1 );
            s1:=c+'0.'+m+'e'+s1;
            zeros:='00000000000000000000000000000000';
            if k<=0 then      s2:=c+'0.'+copy(zeros,1,-k)+m
            else if k>=n then s2:=c+m+copy(zeros,1,k-n)
            else              s2:=c+copy(m,1,k)+'.'+copy(m,k+1,n-k);
            if s1[0]<s2[0] then str:=s1 else str:=s2;
            end;
          end;

function  StrDecim (r:real; Decim: integer): string;
          var m,c,s1,s2,zeros : string[30];
             k,n : integer;
          begin
          if r=0 then StrDecim:='0' else
            begin
            if r<0.0 then c:='-' else c:='';
            r:= abs(r); k:=0;
            while r>=1.0 do  begin r:=r*0.1;  Inc(k) end;
            while r< 0.1-1e-10 do  begin r:=r*10.;  Dec(k) end;
            System.Str ( Round (r*1e9),m );
            if length (m) = 10 then Inc(k);
            while  (length(m)>0) and (m[length(m)]='0') do Dec (m[0]);
            if (length(m)>Decim) and (Decim>=0) then m[0]:= char(Decim);
            n:=length(m);
            System.Str ( k,s1 );
            s1:=c+'0.'+m+'e'+s1;
            zeros:='00000000000000000000000000000000';
            if k<=0 then      s2:=c+'0.'+copy(zeros,1,-k)+m
            else if k>=n then s2:=c+m+copy(zeros,1,k-n)
            else              s2:=c+copy(m,1,k)+'.'+copy(m,k+1,n-k);
            if s1[0]<s2[0] then StrDecim:=s1 else StrDecim:=s2;
            end;
          end;

function  Val (s:string)  : real;
          var e: extended; i, code: integer;
          begin
          i:=1; while (i<=length(s)) and
                      not (s[i] in ['0'..'9','.','+','-']) do Inc(i);
          delete(s,1,i-1);
          i:=1; while (i<=length(s)) and
                      (s[i] in ['0'..'9','.','+','-','e','E']) do Inc(i);
          s[0] := chr (i-1);
          System.Val (s, e, code);
          if (code=0) and (abs(e)<1.7e38)
            then Val := e
            else Val := 0;
          end;

procedure CalcGrid (a, b: real; VAR N, sgn: integer; VAR a0, H: real);
          var k: integer;
          begin
          H:= abs ((b-a)/N);
          k:= round ( ln(H)/ln(10)-0.5 );
          H:= H/ exp ( ln(10)*k );
          if H<=2 then H:=2 else if H<=5 then H:=5 else H:=10;
          if H<7  then sgn:=-k else sgn:=-k-1;
          if sgn<0 then sgn:=0;
          H := H* exp ( ln(10)*k );
          a0:= H*round ( a/H+0.5 );
          N := trunc ( (b-a0)/H );
          end;

function  realDiv (x, y, If_y_Zero: real): real;
          var Big: Extended;
          begin
          Big:= 1e+38;
          realDiv:= If_y_Zero;
          if abs(x) < abs(y*Big) then realDiv:= x/y;
          end;

function  doubDiv (x, y, If_y_Zero: double): double;
          var Big: Extended;
          begin
          Big:= 1e+308;
          doubDiv:= If_y_Zero;
          if abs(x) < abs(y*Big) then doubDiv:= x/y;
          end;

function  Ran (a, b: real): real;
          begin
          Ran:= a + (b-a) * Random ($FFFF) / $FFFF;
          end;
END.