UNIT      KEYS;

          INTERFACE

USES      Crt;

TYPE      KeyCode= integer;

CONST     mskPress=   15;
          mskNull=    0;
          mskRShift=  1;
          mskLShift=  2;
          mskShift=   3;
          mskCtrl=    4;
          mskAlt=     8;

VAR       LastKey: KeyCode;
          LastStatus: byte;
          LastChar: char;
          FullCode: Word;

function  WaitKey: KeyCode;
function  MyKeyPressed: boolean;
procedure PutKey (Key: KeyCode);
procedure ClearRemainKeys;
function  RemainKeysCount: integer;

          IMPLEMENTATION

CONST     StackLen=50;
VAR       KeyStack: array [0..StackLen-1] of KeyCode;
          Top, Bottom: integer;

function  WaitKey: KeyCode;
          begin
          if Bottom=Top then
            repeat
              LastKey:= ord(ReadKey);
              if LastKey=0 then LastKey:= -ord(ReadKey);
              PutKey (LastKey);
            until not MyKeyPressed;
          Bottom:= (Bottom+1) mod StackLen;
          LastKey:= KeyStack [Bottom];
          WaitKey:= LastKey;
          LastChar:= chr (abs (LastKey));
          LastStatus:= Mem [$0040:$0017] and mskPress;
          end;

function  MyKeyPressed: boolean;
          var Head, Tail: Byte;
          begin
          Head:= Mem[$40:$1A];
          Tail:= Mem[$40:$1C];
          MyKeyPressed:= (Head<>Tail);
          if (Head<>Tail) then FullCode:= Mem[$40:Head+1];
          end;

procedure PutKey (Key: KeyCode);
          begin
          Top:= (Top+1) mod StackLen;
          KeyStack [Top]:= Key;
          end;

function  RemainKeysCount: integer;
          begin
          RemainKeysCount:= abs (Top-Bottom);
          end;

procedure ClearRemainKeys;
          begin
          Top:=0; Bottom:=0;
          end;
BEGIN
          ClearRemainKeys
END.