UNIT IniFile;

     INTERFACE
CONST
     stEOF= 0;     {ப  }
     stRemark= 1;  {਩}
     stValue= 2;   {祭}
     stTopic= 3;   {ࠧ}
     stCommon= 99; {㣠}
TYPE
     PIniFile= ^TIniFile;
     TIniFile= object
       F: Text;
       OK: boolean;
       Buf: String;
         constructor Init (FileName: String);
         destructor  Done;
         function    NextLine: integer;
         function    VarName: String;
         function    VarValue: String;
         function    TopicName: String;
       end;

     IMPLEMENTATION
USES Serv;

constructor TIniFile.Init (FileName: String);
            begin
            assign (F, FileName);
            {$I-} reset (F); {$I+}
            OK:= ioResult=0;
            Buf:='';
            end;

destructor  TIniFile.Done;
            begin
            if OK then close (F);
            end;

function    TIniFile.NextLine: integer;
            begin
            if not OK or EOF(F) then
              NextLine:= stEOF
            else begin
              ReadLn (F,Buf); TrunLR (Buf);
              if Buf[1]=';' then
                NextLine:= stRemark
              else if (Buf[1]='[') and (Buf[length(Buf)]=']') then
                NextLine:= stTopic
              else if pos ('=', copy (Buf,2,255))>0 then
                NextLine:= stValue
              else
                NextLine:= stCommon;
              end;
            end;

function    TIniFile.VarName: String;
            var Tmp: String;
            begin
            Tmp:= copy (Buf, 1, pos('=', copy (Buf,2,255)));
            TrunLR (Tmp);
            VarName:= Tmp;
            end;

function    TIniFile.VarValue: String;
            var Tmp: String;
            begin
            Tmp:= copy (Buf, pos('=', copy (Buf,2,255))+2, 255);
            TrunLR (Tmp);
            VarValue:= Tmp;
            end;

function    TIniFile.TopicName: String;
            var Tmp: String;
            begin
            Tmp:= copy (Buf,2,length(Buf)-2);
            TrunLR (Tmp);
            TopicName:= Tmp;
            end;
END.