UNIT Arrays;

     INTERFACE
TYPE
     TIndex= word;
     PIndex= ^TIndex;
     TMem= array [0..100] of byte;
     PMem= ^TMem;
     PPointer= ^Pointer;

     { ᨢ 祣 㣮. 㬥 ⮢  1. }
     PArray= ^TArray;
     TArray= object
       Mem: PMem;
       n, szElem, szBlock: TIndex;
         constructor Init (nElems, ElemSize, BlockSize: TIndex);
         constructor Copy (var From: TArray);
         destructor  Done; virtual;
         procedure   Resize (nElems: TIndex);
         procedure   Zeroize;
         procedure   DelElems (i, nElems: TIndex);
         procedure   InsElems (i, nElems: TIndex);
         function    Get (i: TIndex; var Val): boolean; virtual;
         function    Put (i: TIndex; var Val): boolean; virtual;
         procedure   Add (var Val); virtual;
         function    Elem (i: TIndex): pointer; virtual;
         function    Size: TIndex; virtual;
         function    RealSize (nElems: TIndex): TIndex;
         end;

     IMPLEMENTATION

constructor TArray.Init (nElems, ElemSize, BlockSize: word);
            begin
            n:= nElems;
            szElem:= ElemSize;
            szBlock:= BlockSize;
            GetMem (Mem, RealSize(n));
            end;

constructor TArray.Copy (var From: TArray);
            begin
            n:= From.n;
            szElem:= From.szElem;
            szBlock:= From.szBlock;
            GetMem (Mem, RealSize(n));
            Move (From.Mem^, Mem^, n*szElem);
            end;

destructor  TArray.Done;
            begin
            FreeMem (Mem, RealSize(n));
            end;

procedure   TArray.Resize (nElems: TIndex);
            var Sz, Sz1, RSz, RSz1, MinSz: word;
                Mem1: PMem;
            begin
            Sz:= n*szElem;        RSz:=  RealSize(n);
            Sz1:= nElems*szElem;  RSz1:= RealSize(nElems);
            if (RSz<>RSz1) then begin
              GetMem (Mem1, RSz1);
              if Sz<Sz1 then MinSz:= Sz else MinSz:= Sz1;
              Move (Mem^, Mem1^, MinSz);
              FreeMem (Mem, RSz);
              Mem:= Mem1;
              end;
            if Sz1>Sz then FillChar (Mem^[Sz], Sz1-Sz, 0);
            n:= nElems;
            end;

procedure   TArray.Zeroize;
            begin
            FillChar (Mem^, n*szElem, 0);
            end;

function    TArray.Elem (i: TIndex): pointer;
            begin
            if (1<=i) and (i<=n)
              then Elem:= Addr (Mem^[(i-1)*szElem])
              else Elem:= nil;
            end;

function    TArray.Get (i: TIndex; var Val): boolean;
            var P: ^Byte;
            begin
            P:= TArray.Elem (i);
            if P<>nil then Move (P^, Val, szElem);
            Get:= (P<>nil);
            end;

function    TArray.Put (i: TIndex; var Val): boolean;
            var P: ^Byte;
            begin
            P:= TArray.Elem (i);
            if P<>nil then Move (Val, P^, szElem);
            Put:= (P<>nil);
            end;

procedure   TArray.Add (var Val);
            var P: ^Byte;
            begin
            Resize (n+1);
            P:= TArray.Elem (n);
            if P<>nil then Move (Val, P^, szElem);
            end;

procedure   TArray.DelElems (i, nElems: TIndex);
            var dest, sour, c, coun: TIndex;
            begin
            if (0<i) and (i<=n) then begin
              if i+nElems-1>n then nElems:= n-i+1
                else begin
                  dest:= (i-1)*szElem;
                  sour:= (i+nElems-1)*szElem;
                  coun:= (n-i-nElems+1)*szElem;
                  if coun>0 then for c:= 0 to coun-1 do
                    Mem^[dest+c]:= Mem^[sour+c];
                  end;
              Resize (n-nElems);
              end;
            end;

procedure   TArray.InsElems (i, nElems: TIndex);
            var dest, sour, coun, c: TIndex;
                Sz, Sz1, MinSz: word;
                Mem1: PMem;
            begin
            if (i<1) then i:=1;
            if (i>n) then i:=n+1;
            Resize (n+nElems);
            dest:= (i+nElems-1)*szElem;
            sour:= (i-1)*szElem;
            coun:= (n-i-nElems+1)*szElem;
            if coun>0 then for c:= coun-1 downto 0 do
              Mem^[dest+c]:= Mem^[sour+c];
            end;

function    TArray.Size: TIndex;
            begin
            Size:= n;
            end;

function    TArray.RealSize (nElems: TIndex): TIndex;
            begin
            RealSize:= szElem;
            if (nElems>0) then
              RealSize:= ((nElems-1) div szBlock + 1) * szBlock * szElem;
            end;
END.