UNIT CwLib;

     INTERFACE
USES
     Arrays, MatPlus;
CONST
     MAXKEY= 48;
     MAXFONT= 20;
     SYSFONT= 0;
TYPE
     PString= ^String;
     TCharArr= array [1..100] of char;
     PCharArr= ^TCharArr;

     PSftChar= ^TSftChar;
     PSftFont= ^TSftFont;
     PFont= ^TFont;
     PFonts= ^TFonts;
     PSymbol= ^TSymbol;
     PRow= ^TRow;
     PStringBuffer= ^TStringBuffer;
     PSign= ^TSign;
     PRect= ^TRect;
     PSubLine= ^TSubLine;
     POutputStream= ^TOutputStream;
     PLine= ^TLine;
     PConverter= ^TConverter;

     { ᪮ ࠦ ᨬ ⠭⭮ ࠩ୮  }
     TSftChar= object (TBinVector)
         constructor Init (Width, Height: integer);
         destructor  Done; virtual;
         procedure   ShowChar (x, y, Width, Height: integer);
       end;

     { ᪨ ࠦ  ᨬ  }
     TSftFont= object (TArray)
       Name: string[8];
       Width, Height: integer;
         constructor Init;
         destructor  Done; virtual;
         procedure   Load (FileName: string);
         procedure   ShowChar (x,y: integer; Ch: char);
         procedure   ShowAll (var y: integer);
       end;

     { ४஢ ᨬ  }
     TFont= object
       Name: String[8];
       SftFont: PSftFont;
       isMath: boolean;
       isDraw: boolean;
       Command: String[30];
       Chars: String[2*MAXKEY];
       CharSeq: array [1..2*MAXKEY] of PString;
       Fonts: PFonts;
       NextFont: PFont;
         constructor Init (_Fonts: PFonts);
         destructor  Done;
         procedure   SetCharCodes (Key, S: String);
         procedure   SetCharSeq (Ch: char; ChSeq: String);
         procedure   CopyCharSeq (Font: PFont);
         function    GetCharCode (Ch: char): char;
         function    GetCharSeq (Ch: char): PString;
         procedure   LoadSftFont;
       end;

     {  ࠡ ⮢ ࠩ୮ ⥪   ४஢ }
     TFonts= object
       FirstFont: PFont;
       ThisTextFonts: array [0..MAXFONT] of PFont;
       AllKeys: String;
       AllFontKeys: String;
       KeysTable: array [char] of byte;
         constructor Init;
         destructor  Done;
         procedure   AddFont (Font: PFont);
         function    FindFont (FontName: String): PFont;
         function    FontNumber (FontChar: char): byte;
         function    Show (x,y: integer): integer;
       end;

     {  ࢨ筮 ࠡ⪨ ᨬ }
     TSymbol= object
       FontNum: byte;   {   1  MAXFONT }
       Ch: char;        {  ᨬ,     室 䠩 }
       ChSeq: PString;  { 㪠⥫  ᨬ ४஢ }
         function    isBlank: boolean;
         function    isPunctuation: boolean;
         function    isHorizLine: boolean;
       end;

     {  ப }
     TRowStatus= (rsPlus, rsMain, rsMinus);
     TRow= object (TArray)
       Status: TRowStatus;
         constructor Init;
         destructor  Done; virtual;
       end;

     { ப  }
     TStringBuffer= object (TArray)
         constructor Init;
         destructor  Done; virtual;
         procedure   Clear;
         procedure   PutChar (Ch: char); virtual;
         procedure   PutStr (S: String);
         procedure   PutBuf (var Buf: TStringBuffer);
         function    Chars: PCharArr;
         procedure   Back (nElems: integer);
         procedure   TrunBlanks;
         procedure   TrunBlanksLR;
       end;

     { 室 ⮪ }
     TOutputStream= object (TStringBuffer)
       F: Text;
       LastBOL, LastBlank: integer;
       LineLen, nLines, iLine: integer;
         constructor Init (FileName: String; _nLines,_LineLen: integer);
         destructor  Done; virtual;
         procedure   PutChar (Ch: char); virtual;
         procedure   InsertEOL (i: integer);
         procedure   PutEOL;
         procedure   SendToFile;
         procedure   SendLineToFile;
         function    Show (x,y: integer): integer;
       end;

     {  ᨬ 箪 }
     TSign= object
       Font: PFont;
       sChi: String[10];
       sTex: String[18];
       Mask: word;
         procedure Init (ChiTex: String; _Font: PFont; _Mask: word);
       end;

     { אַ㣮쭨 }
     TRect= object
       r1, r2: integer;        { ࠩ ப }
       c1, c2: integer;        { ࠩ  }
       end;

     { אַ㣮쭠   ப }
     TSubLine= object (TStringBuffer)
       Rect: TRect;       { ࠭  }
       Line: PLine;            { 뫪  ப }
       Fonts: PFonts;          { 뫪    }
       r0: integer;            {  ப }
       nGroups: integer;       { ᫮ 㯯, 뢠   }
       nBraces: integer;       { ᫮  ᪮,   - ⭮! }
       nItem: integer;         { ᫥ 祭  㭪 }
       CurrFontComm: PString;  { ⥪  ᬥ  }
       rFound,cFound: integer; { १ ᫥ ᪠ ᨬ }
       isMath: boolean;        { ⥬᪠  ? }
       isSubLine: boolean;     { ४ 㡨  1 ? }
       isSubSubLine: boolean;  { ४ 㡨  2 ? }
       isReference: boolean;   { । ப - ஭.㫠 ? }
       isDisplayMath: boolean; { 뤥 ⥬᪠  ? }
       isProlongMath: boolean; { த   ப ⬮ ? }
         constructor Init (var _Rect:TRect;_r0:integer;_Line:PLine;_Fonts:PFonts);
         destructor  Done; virtual;
         procedure   Make;
         procedure   MakeLineBegin (var c: integer);
         function    MakeSymbol (var Sym: TSymbol; var isMathSym: boolean): String;
         function    MakeSubline (rz,r1,r2,c1,c2: integer): PSubline;
         function    MakeIndex (r,r1,r2,c: integer; IndCh: char): integer;
         procedure   MakeLimits (r,r1,r2,c1,c2: integer);
         function    MakeFraction (r,c: integer): integer;
         procedure   MakeAccent (var Buf: String; r,c: integer);
         procedure   MakeReference (var Buf: String);
         procedure   MakePunctuation (var Buf: String);
         procedure   MakeModeChange (isMathSym: boolean);
         procedure   MakeFontChange (FontComm: PString);
         function    FindSymbol (var Sym: TSymbol; r1,r2,c1,c2: integer): boolean;
         function    FindPsgraph (Ch: char; c,r1,r2: integer): integer;
         function    FindBigSign (r1,r2,c:integer; var rU,rL:integer): PSign;
         function    FindBase (var R: TRect): integer;
         function    FindReference (var r,c1,c2: integer; var RefStr: String): boolean;
         function    isEmptyCol (c: integer): boolean;
         function    isBlank (var Sym: TSymbol): boolean;
         function    isBigSign   (r:integer; var c: integer): boolean;
         function    isWideSign  (r:integer; var c: integer): boolean;
         function    isOverline  (r:integer; var c: integer): boolean;
         function    isUnderline (r:integer; var c: integer): boolean;
         function    isRadical   (r:integer; var c: integer): boolean;
         function    isFootnote  (r:integer; var c: integer): boolean;
         function    isMathLine: boolean;
         function    isJustLine: boolean;
         procedure   SkipEmpty (var c: integer);
         function    SkipBlanks (var c: integer): boolean;
         procedure   FillBlanks (r1,r2,c1,c2: integer);
         procedure   Substring (r0s, c1s, c2s: integer; var Res: String);
         procedure   BeginLine;
         procedure   FinishLine;
       end;

     { ப ࠩ୮ ⥪ - ᨢ ப }
     TLine= object (TArray)
       nItem, nBraces: integer;
       CurrFontNum: byte;
       CurrFontComm: PString;
       Status: byte;
       yScreen: integer;
       isParEnd: boolean;
       isMath: boolean;
       isProlongMath: boolean;
         constructor Init;
         destructor  Done; virtual;
         procedure   Clear;
         {  ப, ࠡ  ᨢ ப }
         function    AddRow: PRow;
         procedure   AddSymbol (var Sym: TSymbol);
         procedure   AddString (Buf: String; var Fonts: TFonts);
         function    GetSymbol (r,c: integer; var Sym: TSymbol): boolean;
         procedure   PutSymbol (r,c: integer; var Sym: TSymbol);
         { ࠡ⪠, ᯮ, ࠭ }
         procedure   ReplaceChars (var Fonts: TFonts);
         procedure   Make (Fonts: PFonts; var Out: TOutputStream);
         function    MakeTable (Fonts: PFonts; var Out: TOutputStream): boolean;
         function    MainRow: integer;
         function    LineLength: integer;
         function    isEmptyRow (r: integer; Fonts: PFonts): boolean;
         function    isEmptyCol (c: integer; Fonts: PFonts): boolean;
         { 㠫  뢮 }
         procedure   ShowInTextMode;
         procedure   ShowInGraphMode;
         procedure   ShowAsChiWriter (var Fonts: TFonts);
         procedure   Output (var Out: TOutPutStream);
       end;

     { ⢥ ८ࠧ⥫ CHI -> TEX }
     TMakeResult= (mrNormal, mrBreak);
     TConverter= object
       Inp: Text;
       Out: TOutputStream;
       Fonts: TFonts;
       Line: TLine;
       BigSigns: TArray; { array of TSign }
       WideSigns: TArray; { array of TSign }
       Accents: TArray; { array of TSign }
       JobMode: integer;
         constructor Init (InpFileName: String);
         destructor  Done;
         procedure   LoadIni (IniFileName: String);
         procedure   Make;
         function    LineBegins (var Buf: String; var Status: byte): boolean;
         function    LineEnds (var OldBuf, Buf: String): boolean;
         function    MakeLine: TMakeResult;
       end;
VAR
     Main: TConverter;

     IMPLEMENTATION
USES
     Crt, DOS, EgaVga, Graph, IniFile, Serv, Keys;
CONST
     { ப ࠬ }
     FontDir: String= '';
     FontExt: String[3]= 'sft';
     EndText: String= '\end{document}';
     MainFont: String[10]= '\rm';
     chPunctuation: String= ',.;:?!)';
     chHorizLine: String= '';
     { ࠬ 㠫쭮 ।⠢ }
     RowDist: integer= 5;     { ﭨ  ப,  ᥫ }
     coBgrd: integer= 1;      { 梥 䮭 }
     coText: integer= 15;     { 梥 ⥪ }
     nViewLines: integer= 25; { ᫮ ப 室 ⥪  ࠭ }
     TeXLineLim: integer= 70; { ᨬ쭠  ப }
     { ࠬ ⬮ }
     TabuPos: integer= 6;     { ࢠ  ⠡ }
     RefBegin: integer= 60;   { 砫  ஢ 뤥  }
     RefEnd: integer= 80;     {   ஢ 뤥  }
     OpenRef: char= '(';      { 뢠 뫪   }
     CloseRef: char= ')';     { 뢠 뫪   }
     MathCol: integer= 1;     {  ⮩   뤥 㫠 }
     {  ᯥᨬ  SYSTEM }
     ssJust: char= 'y';  {\^ - ࠢ}
     ssTab: char= 'v';   {\[ - ⠡}
     ssPend: char= 'a';  {\, -  }
     ssRad: char= '';   { 祢 ᨬ ࠤ }
     ssFoot: char= 'x';   { ⪠-뫪  footnote }
     {  ࢠ ᨬ, ⨬ LaTex' }
     Legal1a= $20; Legal1b= $AF;
     Legal2a= $E0; Legal2b= $F1;
     {  ० ࠡ⪨ ⥪ }
     jmAsciiWork= 0;
     jmAsciiDebug= 1;
     jmTexWork= 2;
     jmTexDebug= 3;
     xScreen0= 27;
     FontColor: array [0..MAXFONT] of byte = (
       8,15,2,3,4,5,6,7,9,10,11,12,13,14,15,10,11,12,13,14,1);
     FontsTextAttr: array [0..MAXFONT] of byte = (
       { 0    1    2    3    4    5    6    7    8    9   10 }
       $08, $1F, $1E, $1D, $1C, $1B, $1A, $17, $19, $12, $13,
            $2F, $2E, $29, $28, $2B, $2A, $25, $21, $24, $20);

(*************************************************************************)
{ 訢 짮⥫ }
(*
function    UserReply (Question: String): String;
            var Rep: String;
                i: integer;
            function X: integer;
                begin X:= (length(Question)+i)*8 end;
            begin
            SetColor (7); i:=0;
            OutTextXY (0,0,Question);
            repeat
              SetColor (7); Line (X+8,10,X+15,10);
              WaitKey;
              SetColor (0); Line (X+8,10,X+15,10);
              SetColor (7);
              if (LastKey=8) and (i>0) then begin
                SetColor(0); OutTextXY (X,0,''); Dec(i);
                end
              else if (LastKey>=32) and (i<50) then begin
                Inc(i); Rep[i]:=chr(LastKey); OutTextXY (X,0,Rep[i])
                end;
            until LastKey=13;
            Rep[0]:=chr(i);
            UserReply:= Rep;
            end;
*)
function    UserReply (Question: String): Char;
            var i: integer;
            begin
            SetColor (7); i:=0;
            OutTextXY (0,0,Question);
            repeat
              WaitKey;
            until Pos (LastChar,'YyNn')>0;
            UserReply:= LastChar;
            if LastChar='Y' then UserReply:='y';
            if LastChar='N' then UserReply:='n';
            end;
(*************************************************************************)
{  ᪮ ࠦ  ᨬ }
constructor TSftChar.Init (Width, Height: integer);
            begin
            TBinVector.Init (Width*Height);
            Fill ($55);
            end;

destructor  TSftChar.Done;
            begin
            TBinVector.Done;
            end;

{ 뢮 ᪮ ࠦ ᨬ   樨 }
procedure   TSftChar.ShowChar (x, y, Width, Height: integer);
            var cx, cy, Col: integer;
            begin
            GraphBegin;
            for cx:= x to x+Width-1 do
              for cy:= y to y+Height-1 do begin
                if At((cy-y)*Width+cx-x+1) then
                  PutPixel (cx,cy,coText);
                end;
            end;

(*************************************************************************)
{   ᪨ ࠦ  ᨬ  }
constructor TSftFont.Init;
            begin
            TArray.Init (0, sizeOf(PSftChar), 50);
            end;

destructor  TSftFont.Done;
            var i: integer;
                sft: PSftChar;
            begin
            for i:= 1 to Size do
              if Get(i,sft) then Dispose (sft,Done);
            TArray.Done;
            end;

{ 㦠 ᪨ ࠦ  ᨬ   *.?FT 䠩 }
procedure   TSftFont.Load (FileName: string);
            type TFontHeader= record  {  䠩 }
                ten: byte;
                Name: array [0..12] of char;
                w1,w2: word;
                b1,Width,Height,b2: byte;
                w: array [1..5] of word;
                rem: array [$20..$157] of byte;
                end;
            var F: file;
                Head: TFontHeader;
                nChars,CharSize,i: integer;
                sft: PSftChar;
            begin
            assign (F, FileName);
            reset (F, 1);
            { ⠥ , 몮ਢ    : }
            BlockRead (F, Head, sizeof(Head));
            Width:= Head.Width;
            Height:= Head.Height;
            CharSize:= Width*Height div 8;
            if Width*Height mod 8 > 0 then Inc(CharSize);
            { 塞 ᫮ ᨬ   १ ࠧ ⪠ 䠩 }
            nChars:= (FileSize(F)-sizeof(Head)) div CharSize;
            i:=0;
            while (Head.Name[i]<>#0) and (Head.Name[i]<>'.') do begin
              Inc(i); Name[i]:= Head.Name[i-1];
              end;
            Name[0]:= chr(i);
            Resize (nChars);
            { 㦠 ᨬ  ।: }
            for i:= 1 to nChars do begin
              new (sft, Init(Width,Height));
              Put (i,sft);
              BlockRead (F, sft^.Row^, CharSize);
              end;
            close (F);
            end;

{ 뢥 ᫥⥫쭮  ᨬ ,  誠 }
procedure   TSftFont.ShowAll (var y: integer);
            var i,j,x,y0,nL: Integer;
                sft: PSftChar;
            const
                x0=20; HexDigit: String[16] = '0123456789ABCDEF';
            begin
            GraphBegin; y0:=y;
            nL:= (Size-1) div 16 + 1;
            SetColor (7);
            for j:= 0 to 16 do begin
              x:= x0+j*(Width+3);
              Line (x,y0,x,y0+nL*(Height+3));
              OutTextXY (x+2,y0-16,HexDigit[j+1]);
              end;
            for i:= 0 to nL do begin
              y:= y0+i*(Height+3);
              Line (x0,y,x0+16*(Width+3),y);
              if i<nL then OutTextXY (x0-16,y+2,HexDigit[i+3]);
              end;
            for i:= 1 to Size do
              if Get(i,sft) then begin
                x:= x0+2 + (i mod 16) * (Width+3);
                y:= y0+2 + (i div 16) * (Height+3);
                sft^.ShowChar (x,y,Width,Height);
                end;
            end;

{ 뢥 ᨬ    樨 }
procedure   TSftFont.ShowChar (x,y: integer; Ch: char);
            var sft: PSftChar;
            begin
            if Get(Ord(Ch)-Ord(' '),sft) then
              sft^.ShowChar (x,y,Width,Height);
            end;

(*************************************************************************)
{  ४஢ ᨬ  }
constructor TFont.Init (_Fonts: PFonts);
            var i: integer;
            begin
            Fonts:=_Fonts;
            NextFont:= nil;
            SftFont:= nil;
            for i:= 1 to 2*MAXKEY do begin
              Chars[i]:=#0;
              CharSeq[i]:=nil;
              end;
            Chars[0]:= chr (2*MAXKEY);
            isMath:= FALSE;
            isDraw:= FALSE;
            Command:= '';
            end;

destructor  TFont.Done;
            var i: integer;
            begin
            if SftFont<>nil then Dispose (SftFont,Done);
            for i:= 1 to 2*MAXKEY do
              if CharSeq[i]<>nil then
                FreeMem (CharSeq[i], length(CharSeq[i]^)+1);
            end;

{  ப ᨬ ४஢  }
procedure   TFont.SetCharCodes (Key, S: String);
            var  i0,i: integer;
            begin
            if Key='AK' then i0:=0 else
            if Key='BK' then i0:=MAXKEY else exit;
            for i:= 1 to length(S) do
              if i<=MAXKEY then
                if S[i]=''
                  then Chars[i0+i]:= ' '
                  else Chars[i0+i]:= S[i];
            Chars[0]:= chr (2*MAXKEY);
            end;

{  ᨬ ४஢ ChSeq  ᨬ
    ᨬ쭮 ४஢ Ch }
procedure   TFont.SetCharSeq (Ch: char; ChSeq: String);
            var iCh: integer;
            begin
            for iCh:= 1 to 2*MAXKEY do
              if Ch=Chars[iCh] then begin
                if CharSeq[iCh]<>nil then
                  FreeMem (CharSeq[iCh], length(CharSeq[iCh]^)+1);
                GetMem (CharSeq[iCh], length(ChSeq)+1);
                CharSeq[iCh]^:= ChSeq;
                end;
            end;

{ ⢮  ᨬ ४஢    }
procedure   TFont.CopyCharSeq (Font: PFont);
            var iCh: integer;
            begin
            if Font=nil then exit;
            for iCh:= 1 to 2*MAXKEY do
              if Font^.CharSeq[iCh]<>nil then
                SetCharSeq (Font^.Chars[iCh], Font^.CharSeq[iCh]^);
            end;

{ 頥 ᨬ ४஢ ண ᨬ Ch }
function    TFont.GetCharCode (Ch: char): char;
            var iCh: integer;
            begin
            GetCharCode:='';
            iCh:= Fonts^.KeysTable[Ch];
            if (iCh<>0) and (Chars[iCh]<>#0) then
              GetCharCode:= Chars[iCh];
            end;

{ 頥 ᨬ ४஢ ண ᨬ Ch }
function    TFont.GetCharSeq (Ch: char): PString;
            var iCh: integer;
            begin
            GetCharSeq:= nil;
            iCh:= Fonts^.KeysTable[Ch];
            if (iCh<>0) and (CharSeq[iCh]<>nil) then
              GetCharSeq:= CharSeq[iCh];
            end;

{ 㦠 ࠭  }
procedure   TFont.LoadSftFont;
            var FullName: String;
            begin
            TrunUp (FontDir);
            if (FontDir<>'') and (FontDir[length(FontDir)]<>'\') then
              FontDir:= FontDir+'\';
            if SftFont<>nil then Dispose (SftFont,Done);
            new (SftFont, Init);
            SftFont^.Load (FontDir+Name+'.'+FontExt);
            end;

{*************************************************************************}
{     ⮢,  ⮬ ᫥ ⨢ }
constructor TFonts.Init;
            var i: integer;
            begin
            FirstFont:= nil;
            for i:= 1 to MAXFONT do
              ThisTextFonts[i]:= nil;
            AllKeys:=
              '`1234567890-=\qwertyuiop[]asdfghjkl;''zxcvbnm,./ '+
              '~!@#$%^&*()_+|QWERTYUIOP{}ASDFGHJKL:"ZXCVBNM<>? ';
            AllFontKeys:=
              '1234567890!"#$%&''()*';
            FillChar (KeysTable, sizeof(KeysTable), #0);
            for i:= 1 to length(AllKeys) do
              KeysTable[AllKeys[i]]:= i;
            end;

destructor  TFonts.Done;
            var f, nf: PFont;
            begin
            f:= FirstFont;
            while f<>nil do begin
              nf:= f^.NextFont;
              Dispose (f, Done);
              f:= nf;
              end;
            end;

{         }
procedure   TFonts.AddFont (Font: PFont);
            begin
            Font^.NextFont:= FirstFont;
            FirstFont:= Font;
            end;

{       ᯨ᪥   ⮢ }
function    TFonts.FindFont (FontName: String): PFont;
            var f: PFont;
            begin
            TrunUp (FontName);
            f:= FirstFont;
            while f<>nil do begin
              if FontName=f^.Name then begin
                FindFont:= f; exit;
                end;
              f:= f^.NextFont;
              end;
            FindFont:= nil;
            end;

{ 뤠    ᨬ, 饬   室 ⥪ }
function    TFonts.FontNumber (FontChar: char): byte;
            begin
            FontNumber:= pos (FontChar, AllFontKeys);
            end;

function    TFonts.Show (x,y: integer): integer;
            var i: integer;
            begin
            for i:= 1 to MAXFONT do
              if ThisTextFonts[i]<>nil then begin
                SetColor (FontColor[i]);
                Inc (y, 10);
                OutTextXY (x,y, ThisTextFonts[i]^.Name);
                end;
            Show:=y;
            end;

{*************************************************************************}
procedure   TSign.Init (ChiTex: String; _Font: PFont; _Mask: word);
            var p,i: integer;
            begin
            TrunLR (ChiTex);
            sChi:= ChiTex; sTex:= '';
            Mask:= _Mask;
            Font:= _Font;
            p:= pos (' ',ChiTex);
            for i:= 1 to length(ChiTex) do
              if ChiTex[i]='' then ChiTex[i]:=' ';
            if p>0 then begin
              sChi:= copy (ChiTex,1,p-1);
              sTex:= copy (ChiTex,p+1,255);
              end;
            end;

{*************************************************************************}
function    TSymbol.isBlank: boolean;
            begin
            isBlank:= (Ch=' ') or ((FontNum=0) and (Ch<>ssFoot));
            end;

function    TSymbol.isPunctuation: boolean;
            begin
            isPunctuation:= (ChSeq=nil) and (pos (Ch,chPunctuation)>0);
            end;

function    TSymbol.isHorizLine: boolean;
            begin
            isHorizLine:= {(ChSeq=nil) and} (pos (Ch,chHorizLine)>0);
            end;

{*************************************************************************}
{ ப ࠩ୮ ⥪ }
constructor TRow.Init;
            begin
            TArray.Init (0, sizeof(TSymbol), 80);
            Status:= rsMain;
            end;

destructor  TRow.Done;
            begin
            TArray.Done;
            end;

{*************************************************************************}
constructor TStringBuffer.Init;
            begin
            TArray.Init (0, 1, 1024);
            end;

destructor  TStringBuffer.Done;
            begin
            TArray.Done;
            end;

procedure   TStringBuffer.Clear;
            begin
            Resize(0);
            end;

function    TStringBuffer.Chars: PCharArr;
            begin
            Chars:= PCharArr(Mem);
            end;

procedure   TStringBuffer.PutChar (Ch: char);
            begin
            Resize (Size+1); Put (Size, Ch);
            end;

procedure   TStringBuffer.PutStr (S: String);
            var i: integer;
            begin
            for i:= 1 to length(S) do PutChar (S[i]);
            end;

procedure   TStringBuffer.PutBuf (var Buf: TStringBuffer);
            var i: integer;
                Ch: char;
            begin
            for i:= 1 to Buf.Size do
              if Buf.Get (i,Ch) then PutChar(Ch);
            end;

procedure   TStringBuffer.Back (nElems: integer);
            begin
            if nElems>Size then nElems:= Size;
            DelElems (Size-nElems+1, nElems);
            end;

procedure   TStringBuffer.TrunBlanks;
            var i: integer;
                OK: boolean;
                Ch: char;
            begin
            i:= Size; OK:= TRUE;
            while (i>0) and ((Chars^[i]=' ') or (Chars^[i]='')) do Dec(i);
            if i<Size then Resize (i);
            end;

procedure   TStringBuffer.TrunBlanksLR;
            var i: integer;
            begin
            i:=0; while (i<Size) and (Chars^[i+1]=' ') do Inc(i);
            if i>0 then DelElems (1,i);
            i:=0; while (i<Size) and (Chars^[Size-i]=' ') do Inc(i);
            if i>0 then Resize (Size-i);
            end;

{*************************************************************************}
constructor TOutputStream.Init (FileName: String; _nLines,_LineLen: integer);
            begin
            TStringBuffer.Init;
            assign (F, FileName);
            rewrite (F);
            LineLen:= _LineLen;
            nLines:= _nLines;
            LastBOL:= 0; LastBlank:= 0; iLine:= 0;
            end;

destructor  TOutputStream.Done;
            begin
            close (F);
            TStringBuffer.Done;
            end;

procedure   TOutputStream.PutChar (Ch: char);
            var i: integer;
            begin
            if Ch='' then PutEOL else
            if Ch='' then Back(1) else
            if Ch='' then begin
              i:= Size;
              while (i>1) and (pos(Chars^[i-1],' ')>0) do begin
                Ch:=Chars^[i-1]; Chars^[i-1]:=Chars^[i]; Chars^[i]:=Ch;
                Dec(i);
                end;
              end
            else if (Ch=' ') and (Pos(Chars^[Size],' ')>0) then {祣}
            else begin
              Resize (Size+1); Put (Size, Ch);
              if (Size-LastBOL>LineLen) then
                if (LastBlank>LastBOL)
                  then InsertEOL (LastBlank+1)
                  else InsertEOL (LastBOL+LineLen);
              if Ch=' ' then LastBlank:= Size;
              end;
            end;

procedure   TOutputStream.InsertEOL (i: integer);
            begin
            if (i>2) and (Chars^[i-2]='') and (Chars^[i-1]='') then exit;
            InsElems (i,1);
            Chars^[i]:= '';
            LastBOL:= i+1;
            LastBlank:= LastBOL;
            Inc (iLine);
            if iLine>nLines then SendLineToFile;
            end;

procedure   TOutputStream.PutEOL;
            begin
            InsertEOL (Size+1);
            end;

procedure   TOutputStream.SendToFile;
            var i: integer;
            begin
            for i:= 1 to Size do
              if Chars^[i]='' then writeln(F) else write(F,Chars^[i]);
            Clear;
            LastBOL:= 0; LastBlank:= 0; iLine:= 0;
            end;

procedure   TOutputStream.SendLineToFile;
            var i: integer;
            begin
            i:= 1;
            while (i<=Size) and (Chars^[i]<>'') do begin
              write (F,Chars^[i]); Inc(i);
              end;
            if (Chars^[i]='') then writeln(F);
            DelElems (1,i);
            Dec (LastBOL,i); if LastBOL<0 then LastBOL:= 0;
            Dec (LastBlank,i); if LastBlank<0 then LastBlank:= 0;
            Dec (iLine);
            end;

function    TOutputStream.Show (x,y: integer): integer;
            var i, cx, cy: integer;
            begin
            GraphBegin; SetColor (2);
            cx:=x; cy:=y; iLine:=1;
            for i:= 1 to Size do
              if (Chars^[i]='') then begin
                cx:=x; Inc(cy,12); Inc(iLine);
                end
              else begin
                OutTextXY (cx,cy,Chars^[i]); Inc (cx,8);
                end;
            Show:= y+12;
            end;

{*************************************************************************}
constructor TSubLine.Init (var _Rect: TRect; _r0: integer;
                           _Line: PLine; _Fonts: PFonts);
            begin
            TStringBuffer.Init;
            Line:=_Line; Fonts:= _Fonts;
            r0:=_r0; Rect:= _Rect;
            CurrFontComm:= nil;
            isMath:= FALSE;
            isSubLine:= FALSE;
            isSubSubLine:= FALSE;
            isDisplayMath:= FALSE;
            isProlongMath:= FALSE;
            isReference:= FALSE;
            nBraces:= 0;
            nGroups:= 0;
            nItem:= 0;
            end;

destructor  TSubLine.Done;
            begin
            TStringBuffer.Done;
            end;

procedure   Legalize (var Buf: String);
            var i, j, Bi: integer;
            begin
            j:= 0;
            for i:= 1 to length(Buf) do begin
              Bi:= ord(Buf[i]);
              if (Legal1a<=Bi) and (Bi<=Legal1b) or
                 (Legal2a<=Bi) and (Bi<=Legal2b) then begin
                  Inc(j); Buf[j]:= Buf[i];
                  end;
              end;
            Buf[0]:= chr(j);
            end;

{  ࠡ⪠ ப }
procedure   TSubLine.Make;
            var c,cL,cU: integer;
                Sym: TSymbol;
                Buf: String;
                Font: PFont;
                isMathSym: boolean;
            begin
            if (r0<Rect.r1) or (Rect.r2<r0) then exit;
            MakeLineBegin (c);
            while (c<=Rect.c2) do begin
              Line^.GetSymbol (r0,c,Sym);
              Font:= Fonts^.ThisTextFonts[Sym.FontNum];
              if false then {;-}
              else if isFootnote (r0,c) then { ᭮᪠ }
              else if isBigSign (r0,c) then  { ⨪. -  ᮢ! }
              else if isWideSign (r0,c) then { ਧ⠫  }
              else if isRadical (r0,c) then  { ࠤ }
              else if Sym.isHorizLine then   { ஡  }
                c:= MakeFraction (r0,c)
              else if isOverline (r0,c) then { ન }
              else if isUnderline (r0,c) then { ન }
              else if isBlank (Sym) then begin {   ப  }
                cU:= MakeIndex (r0,Rect.r1,r0-1,c,'^'); { 孨  }
                cL:= MakeIndex (r0,r0+1,Rect.r2,c,'_'); {   }
                if (cU>c) or (cL>c) then
                  PutChar(' ');
                if cU>cL then c:=cU else c:=cL;
                end
              else begin
                { , ⮣   ᨬ: }
                Buf:= MakeSymbol (Sym, isMathSym);
                MakeModeChange (isMathSym);
                MakeAccent (Buf, r0, c);
                MakeReference (Buf);
                MakeFontChange (@Font^.Command);
                MakePunctuation (Buf);
                Legalize (Buf);
                PutStr (Buf);
                end;
              Inc (c);
              end;
            end;

{ , ࠡ뢠  頥 ந ப }
function    TSubLine.MakeSubline (rz,r1,r2,c1,c2: integer): PSubline;
            var Sub: PSubline;
                R: TRect;
            begin
            if (r1<=r2) and (c1<=c2) then begin
              R.r1:=r1; R.r2:=r2;
              R.c1:=c1; R.c2:=c2;
              if rz<1 then rz:= FindBase(R);
              New (Sub, Init (R,rz,Line,Fonts));
              Sub^.isMath:= TRUE;
              Sub^.isSubSubLine:= TRUE;
              Sub^.CurrFontComm:= CurrFontComm;
              Sub^.Make;
              Sub^.TrunBlanksLR;
              if Sub^.Size>1 then begin
                Sub^.InsElems (1,1);
                Sub^.Chars^[1]:='{';
                Sub^.PutChar('}');
                end;
              MakeSubline:= Sub;
              end
            else MakeSubline:= nil;
            end;

{ ய᪠   }
procedure   TSubLine.SkipEmpty (var c: integer);
            begin
            while (c<=Rect.c2) and isEmptyCol(c) do Inc(c);
            end;

{ ய᪠ ஡   ,   ய᪠ 让 ᨬ.
   ᮮ頥,    ⮫  ᫥ ய饭 ஡. }
function    TSubLine.SkipBlanks (var c: integer): boolean;
            var Sym: TSymbol;
                c0, rU, rL: integer;
                isEmpty, isFirstEmpty: boolean;
            begin
            c0:=c;
            isEmpty:= isEmptyCol(c);
            isFirstEmpty:= isEmpty;
            while (c<=Rect.c2) do begin
              Line^.GetSymbol (r0,c,Sym);
              if not Sym.isBlank then break;
              isEmpty:= isEmpty or isEmptyCol(c);
              if (FindBigSign (Rect.r1,Rect.r2,c,rU,rL)=nil) or
                (abs(rU+rL-2*r0)>1) then Inc(c) else break;
              end;
            SkipBlanks:= (not isFirstEmpty and isEmpty);
            end;

{ ࠡ⪠ ਧ⠫ : ५, max, min  .. }
function    TSubLine.isWideSign (r:integer; var c: integer): boolean;
            var cc,cc0,i,k: integer;
                Wide: TSign;
                Sym: TSymbol;
                Font: PFont;
                isMatch: boolean;
            begin
            isWideSign:= FALSE;
            cc:=c;
            if SkipBlanks (cc) then exit;
            cc0:=cc;
            for i:= 1 to Main.WideSigns.Size do
              if Main.WideSigns.Get (i,Wide) then begin
                isMatch:= TRUE; k:=1; cc:=cc0;
                repeat
                  Line^.GetSymbol (r,cc,Sym);
                  Font:= Fonts^.ThisTextFonts [Sym.FontNum];
                  isMatch:= (Wide.sChi[k]=Sym.Ch) and (Wide.Font=Font);
                  Inc (k); Inc(cc);
                until (k>length(Wide.sChi)) or not isMatch;
                if isMatch then begin
                  if cc0>c then PutChar (' ');
                  MakeModeChange (TRUE);
                  PutStr (Wide.sTex);
                  SkipBlanks (cc);
                  MakeLimits (r,r,r,c,cc-1);
                  PutChar (' ');
                  isWideSign:= TRUE; c:=cc-1;
                  exit;
                  end;
                end;
            end;

{ ࠡ⪠  ᪮, 㬬, ⥣ࠫ  .. }
function    TSubLine.isBigSign (r:integer; var c: integer): boolean;
            var cc, rU, rL: integer;
                Big: PSign;
            begin
            isBigSign:= FALSE;
            cc:=c;
            if SkipBlanks (cc) then exit;
            Big:= FindBigSign (Rect.r1, Rect.r2, cc, rU, rL);
            if Big<>nil then begin
              if cc>c then PutChar (' ');
              MakeModeChange (TRUE);
              if Big^.Mask=1 then begin {  ᪮,    }
                if nBraces mod 2 = 0
                  then PutStr('\left') else PutStr('\right');
                Inc (nBraces);
                end;
              PutStr (Big^.sTex+' ');
              if Big^.Mask=0 then MakeLimits (r,rU,rL,c,cc);
              PutChar (' ');
              isBigSign:= TRUE; c:=cc;
              end;
            end;

{ ᯮ  ᪮, 㬬, ⥣ࠫ  .. }
function    TSubLine.FindBigSign (r1,r2,c: integer; var rU,rL: integer): PSign;
            var i: integer;
                Big: TSign;

            function isMatch: boolean;
                var r,p,L: integer;
                    Sym: TSymbol;
                    Font: PFont;
                begin
                p:=1; r:=r1; L:=length (Big.sChi);
                while (r<=r2) and (p<=L) do begin
                  Line^.GetSymbol (r,c,Sym);
                  Font:= Fonts^.ThisTextFonts[Sym.FontNum];
                  if (Sym.Ch=Big.sChi[p]) and (Big.Font=Font) then begin
                    if p=1 then rU:=r;
                    if p=L then rL:=r;
                    Inc(p); end;
                  Inc(r); end;
                isMatch:= (p=L+1);
                end;

            begin
            FindBigSign:= nil;
            for i:= 1 to Main.BigSigns.Size do
              if Main.BigSigns.Get (i,Big) and isMatch then begin
                FindBigSign:= Main.BigSigns.Elem(i); exit;
                end;
            end;

{ ࠡ⪠ 孨   ।  ஢ த \sum  \lim.
  箪  㦥  鸞 r1--r2  ⮫ c1--c2 }
procedure   TSubLine.MakeLimits (r,r1,r2,c1,c2: integer);
            var rU,rL: integer;
                Sym: TSymbol;
                Lim: PSubLine;
            begin
            Lim:= MakeSubline (0,r2+1,Rect.r2,c1,c2);
            if (Lim<>nil) and (Lim^.Size>0) then begin
              TrunBlanks;
              PutChar ('_'); PutBuf (Lim^);
              end;
            if (Lim<>nil) then Dispose (Lim, Done);
            Lim:= MakeSubline (0,Rect.r1,r1-1,c1,c2);
            if (Lim<>nil) and (Lim^.Size>0) then begin
              TrunBlanks;
              PutChar ('^'); PutBuf (Lim^);
              end;
            if (Lim<>nil) then Dispose (Lim, Done);
            end;

{ ࠡ⪠ ਧ⠫쭮   㫮 }
function    TSubLine.isOverline (r:integer; var c: integer): boolean;
            var cc,rr,cMax,rMax: integer;
                Sym: TSymbol;
                Sub: PSubline;
            begin
            isOverline:= FALSE;
            cMax:=c;
            { 饬 ᠬ  ਧ⠫  -  }
            for rr:= Rect.r1 to r-1 do begin
              cc:=c;
              while Line^.GetSymbol(rr,cc,Sym) and (cc<=Rect.c2)
                and Sym.isHorizLine do Inc(cc);
              if cc>cMax then begin
                cMax:=cc; rMax:=rr;
                end;
              end;
            if cMax>c+1 then begin
              Sub:= MakeSubline (r0,rMax+1,Rect.r2,c,cMax-1);
              if Sub=nil then exit;
              { 諨  ,    ⮩ }
              MakeModeChange (TRUE);
              TrunBlanks;
              PutStr (' \overline');
              if Sub^.Size=1 then PutChar(' ');
              PutBuf (Sub^);
              Dispose (Sub, Done);
              isOverline:= TRUE;
              c:= cMax-1;
              end;
            end;

{ ࠡ⪠ ਧ⠫쭮   㫮  ⥪⮬ }
function    TSubLine.isUnderline (r:integer; var c: integer): boolean;
            var cc,rr,cMax,rMax: integer;
                Sym: TSymbol;
                Sub: PSubline;
            begin
            isUnderline:= FALSE;
            cMax:=c;
            { 饬 ᠬ  ਧ⠫  -  }
            for rr:= r+1 to Rect.r2 do begin
              cc:=c;
              while Line^.GetSymbol(rr,cc,Sym) and (cc<=Rect.c2)
                and (Sym.isHorizLine or (Sym.Ch='_')) do Inc(cc);
              if cc>cMax then begin
                cMax:=cc; rMax:=rr;
                end;
              end;
            if cMax>c+1 then begin
              Sub:= MakeSubline (r0,Rect.r1,rMax-1,c,cMax-1);
              if Sub=nil then exit;
              { 諨  ,    ⮩ }
              {TrunBlanks;}
              PutStr ('\underline');
              if Sub^.Size=1 then PutChar(' ');
              PutBuf (Sub^);
              Dispose (Sub, Done);
              isUnderline:= TRUE;
              c:= cMax-1;
              end;
            end;

{ ࠡ⪠ ࠤ }
function    TSubLine.isRadical (r:integer; var c: integer): boolean;
            var cc,rr,rRad,cMin,cMax,rMax,cc0,cc1,l,lMax: integer;
                Sym: TSymbol;
                Sub: PSubline;
                isRad, isBar, isPgr: boolean;
                Font: PFont;
            begin
            cc:=c; isRad:= FALSE;
            { 饬 讪 (ssRad=) }
            SkipBlanks (cc);
            for rr:= Rect.r1 to Rect.r2 do
              if Line^.GetSymbol(rr,cc,Sym) and (Sym.Ch=ssRad) then begin
                isRad:= TRUE; rRad:= rr;
                end;
            isRadical:= isRad;
            if isRad then begin
              { , 讪! 砫 ࠡ뢠 ⥫ }
              while Line^.GetSymbol(rRad-2,cc,Sym) and (Sym.Ch='|')
                do Dec(rRad,2);
              Dec (rRad);
              Sub:= MakeSubline (0,Rect.r1,rRad,c,cc);
              MakeModeChange (TRUE);
              if (Sub<>nil) and (Sub^.Size>0) then begin
                PutStr (' \root');
                if Sub^.Size=1 then PutChar(' ');
                PutBuf (Sub^);
                PutStr (' \of');
                end
              else  {  ⥫, ⠫  讪  }
                PutStr (' \sqrt');
              if (Sub<>nil) then Dispose (Sub,Done);
              {  ७ ࠦ }
              cc0:=cc; cMin:=cc0; cMax:=cc0; c:=cc0; lMax:=0;
              { 砫 饬  - ᠬ  楯 isDraw-ᨬ }
              for rr:= Rect.r1 to rRad do begin
                cc:=cc0; isBar:= FALSE;
                while Line^.GetSymbol(rr,cc,Sym) and (cc<=Rect.c2) do begin
                  Font:= Fonts^.ThisTextFonts[Sym.FontNum];
                  isPgr:= not Sym.isBlank and Font^.isDraw;
                  if not isBar and isPgr then begin
                    cc1:=cc; isBar:= TRUE;
                    end
                  else if isBar and not isPgr then break;
                  Inc(cc);
                  end;
                l:= cc-cc1;
                if isBar and (l>lMax) {and (cMax-cMin>1)} then begin
                  cMin:=cc1; cMax:=cc; lMax:=l; rMax:=rr;
                  end;
                end;
              { 誠 : rMax, [cMin--cMax-1] }
              if cMax>cMin then begin
                Sub:= MakeSubline (r0,rMax+1,Rect.r2,cMin,cMax-1);
                if Sub<>nil then begin
                  if Sub^.Size=1 then PutChar(' ');
                  PutBuf (Sub^);
                  Dispose (Sub, Done);
                  end;
                c:= cMax-1;
                end
              else PutStr('{}');
              isRadical:= TRUE;
              end;
            end;

{ ࠡ⪠ 뫪  ᭮ }
function    TSubLine.isFootnote (r:integer; var c: integer): boolean;
            var Sym: TSymbol;
                row: PRow;
                rr,cc: integer;
            begin
            isFootnote:= FALSE;
            cc:= c;
            SkipEmpty (cc);
            for rr:= Rect.r1 to Rect.r2 do
              if Line^.GetSymbol(rr,cc,Sym)
              and (Sym.FontNum=0) and (Sym.Ch=ssFoot) then begin
                Line^.GetSymbol (rr,cc+1,Sym);
                Line^.Get (rr,row);
                row^.DelElems (cc+1,1);
                PutStr ('\footnote{'+Str(ord(Sym.Ch)-32)+'}');
                c:= cc; isFootnote:= TRUE; exit;
                end;
            end;

{ ࠡ⪠ ஡  ਧ⠫쭮 ஡ ⮩ }
function    TSubLine.MakeFraction (r,c: integer): integer;
            var i,c0: integer;
                Sym: TSymbol;
                Num, Den: PSubline;
            begin
            MakeFraction:= c;
            SkipEmpty (c);
            i:=c; c0:=c;
            while Line^.GetSymbol(r,i,Sym) and (i<=Rect.c2)
              and Sym.isHorizLine do Inc(i);
            if i>c0 then begin
              Num:= MakeSubline (0,Rect.r1,r-1,c0,i-1);
              if (Num=nil) then exit;
              Den:= MakeSubline (0,r+1,Rect.r2,c0,i-1);
              if (Den=nil) then begin
                Dispose (Num,Done); exit;
                end;
              MakeFraction:= i-1;
              MakeModeChange (TRUE);
              TrunBlanks;
              PutStr ('\frac');
              if Num^.Size=1 then PutChar (' ');
              if Num^.Size=0 then PutStr('{}') else PutBuf (Num^);
              if Den^.Size=0 then PutStr('{}') else PutBuf (Den^);
              Dispose (Num,Done);
              Dispose (Den,Done);
              end;
            end;

{ ࠡ⪠ 孥 (IndCh='^')   (IndCh='_')  }
function    TSubLine.MakeIndex (r,r1,r2,c: integer; IndCh: char): integer;
            var cc,rU,rL,i,i1,i2: integer;
                Ind: PSubline;
                isPrimes: boolean;
            begin
            MakeIndex:= c;
            cc:=c;
            SkipBlanks (cc);
            Ind:= MakeSubline (0,r1,r2,c,cc-1);
            if (Ind<>nil) then begin
              MakeIndex:= cc-1;
              if (Ind^.Size>0) then begin
                MakeModeChange (TRUE);
                TrunBlanks;
                if Ind^.Size=1
                  then begin i1:=1; i2:=1; end
                  else begin i1:=2; i2:=Ind^.Size-1; end;
                isPrimes:= TRUE;
                for i:= i1 to i2 do
                  isPrimes:= isPrimes and (Ind^.Chars^[i]='''');
                if isPrimes and (IndCh='^') then begin
                  for i:= i1 to i2 do PutChar ('''');
                  end
                else begin
                  PutChar (IndCh); PutBuf (Ind^);
                  end;
                end;
              Dispose (Ind, Done);
              end;
            end;

{ ࠡ⪠ 業⮢  ᪨  }
procedure   TSubLine.MakeAccent (var Buf: String; r,c: integer);
            var Sym: TSymbol;
                Font: PFont;
                Acce: TSign;
                i,k: integer;
                Blank: String[2];
                AcceChi, AcceBuf: String;
            const
                MAXACCE=10;
                TeXacce: array [1..2*MAXACCE] of String[10] = (
                '\hat','\check','\tilde','\acute','\grave',
                '\dot','\ddot', '\breve','\bar',  '\vec',
                '\^','\v','\~','\''','\`','\.','\"','\u','\=','');
            begin
            if r<=Rect.r1 then exit;
            {⠦,  , 業 襬  ப Acc}
            for i:= r-1 downto Rect.r1 do begin
              Line^.GetSymbol (i,c,Sym);
              if i=r-1 then Font:= Fonts^.ThisTextFonts[Sym.FontNum];
              AcceChi[r-i]:= Sym.Ch;
              end;
            AcceChi[0]:= chr(r-Rect.r1);
            TrunLR (AcceChi);
            if length (AcceChi)=0 then exit;
            {饬 ⠪ 業  ⠡ 業⮢}
            for i:= 1 to Main.Accents.Size do
              if Main.Accents.Get (i,Acce)
              and (Pos(Acce.sChi,AcceChi)=1) and (Acce.Font=Font) then begin
                  AcceBuf:= Acce.sTex;
                  if not isMath then for k:= 1 to MAXACCE do
                    if (AcceBuf=TeXacce[k]) then
                      AcceBuf:= TeXacce[MAXACCE+k];
                  if isMath then Blank:=' ' else Blank:='';
                  if length(Buf)=1
                    then Buf:= AcceBuf+Blank+Buf
                    else Buf:= AcceBuf+'{'+Buf+'}';
                  break;
                  end;
            end;

{ ࠡ⪠ ஡ }
function    TSubLine.isBlank (var Sym: TSymbol): boolean;
            {var pc: PChar;}
            begin
            if Sym.isBlank then begin
              {pc:= PChar(Chars);}
              {TrunBlanks;}
              { ⢮: 塞 " - "  ⥪⮢   --- }
              if not isMath and (Chars^[Size]='-') and (Chars^[Size-1]=' ')
                then PutStr ('-- ')
                else PutChar(' ');
              {  ⢮: ⠡ 塞  \qquad }
              if Sym.Ch=ssTab then PutStr ('\qquad ');
              isBlank:= TRUE;
              end
            else isBlank:= FALSE;
            end;

{ 祭 ⥫쭮 ४஢  ᫥   }
function    TSubLine.MakeSymbol (var Sym: TSymbol; var isMathSym: boolean): String;
            var Font: PFont;
                Buf: String;
                L: integer;
            begin
            Font:= Fonts^.ThisTextFonts[Sym.FontNum];
            if Sym.ChSeq=nil then begin
              Buf:= Sym.Ch; isMathSym:= Font^.isMath;
              if Font^.isDraw then Buf:= '';
              end
            else begin
              Buf:= Sym.ChSeq^; L:= length(Buf);
              if (L>2) and (Buf[1]='$') and (Buf[L]='$') then begin
                isMathSym:= TRUE;
                Buf:= System.copy (Buf,2,L-2);
                end
              else if (L>2) and (Buf[1]='@') and (Buf[L]='@') then begin
                isMathSym:= isMath;
                Buf:= System.copy (Buf,2,L-2);
                end
              end;
            isMathSym:= isMathSym or isDisplayMath;
            MakeSymbol:= Buf;
            end;

{ ᯮ  ࠡ⪠ 뫪 ( ⥪)   }
procedure   TSubLine.MakeReference (var Buf: String);
            var i,ii: integer;
            begin
            if (Buf=CloseRef) then begin
              i:= Size;
              while (i>0) and (pos(Chars^[i],'0123456789. ')>0) do Dec(i);
              if Chars^[i]=OpenRef then begin { ⢨⥫쭮 뫪! }
                for ii:= i+1 to Size do Buf[ii-i]:=Chars^[ii];
                Buf[0]:= chr (Size-i);
                TrunLR (Buf);
                Buf:= ' (\ref{eqn'+Buf+'})';
                Back (Size-i+1);
                end;
              end;
            end;

{ ᯮ  ࠡ⪠ , ࠢ 㭪樨 }
procedure   TSubLine.MakePunctuation (var Buf: String);
            var L: integer;
            begin
            if (Buf='.') and (Chars^[Size]='.') and (Chars^[Size-1]='.')
            then begin
              Back (2); Buf:='\dots';
              end;
            L:= length(Buf);
            if (L=1) and (pos(Buf[L],chPunctuation)>0) and (Chars^[Size]=' ')
              then TrunBlanks;
            end;

{ ࠡ⪠ ᬥ ⥬᪮  }
procedure   TSubLine.MakeModeChange (isMathSym: boolean);
            var Ch: char;
                Buf: String;
                wasBlanks: boolean;
            begin
            if isSubSubLine then exit;
            if not isMath and isMathSym then begin {砫 math}
              {if Chars^[Size]<>' ' then PutChar (' ');}
              PutChar ('$');
              nBraces:= 0;
              end;
            if isMath and not isMathSym then begin { math}
              wasBlanks:= Get(Size,Ch) and (Ch=' ');
              if wasBlanks then TrunBlanks;
              if Get(Size,Ch) and (pos(Ch,';,.:-?')>0)
                then Back(1) { ࠬ⭠ ᬥ  ᫥ : }
                else Ch:=#0;
              if nBraces mod 2 = 1 then PutStr ('\right.');
              if Chars^[Size]='$' then Back(1) else PutStr ('$');
              if (Ch='-') then TrunBlanks;
              if (Ch<>#0) then PutChar (Ch);
              if wasBlanks then PutChar (' ');
              end;
            isMath:= isMathSym;
            end;

{ ࠡ⪠ ᬥ   ⥪⮢  }
procedure   TSubLine.MakeFontChange (FontComm: PString);
            var isEmFont: boolean;
                isOutGroup: boolean;
            begin
            if (CurrFontComm=nil) and (FontComm^=MainFont) then exit;
            if isMath or (CurrFontComm^=FontComm^) then exit;
            isEmFont:= (CurrFontComm^<>MainFont);
            isOutGroup:= not isSubLine and not isSubSubLine;
            if isEmFont and (FontComm^=MainFont) and isOutGroup then
              PutStr ('}')
            else if not isEmFont and isOutGroup then
              PutStr ('{'+FontComm^+' ')
            else
              PutStr (FontComm^+' ');
            CurrFontComm:= FontComm;
            end;

{  <ᨬ,>   אַ㣮쭨 }
function    TSubLine.isEmptyCol (c: integer): boolean;
            var r: integer;
                Sym: TSymbol;
            begin
            isEmptyCol:= TRUE;
            for r:= Rect.r1 to Rect.r2 do begin
              Line^.GetSymbol (r,c,Sym);
              if not Sym.isBlank then begin
                isEmptyCol:= FALSE; exit;
                end;
              end;
            end;

{  <ᨬ,>   אַ㣮쭨 }
function    TSubLine.FindSymbol (var Sym: TSymbol; r1,r2,c1,c2: integer): boolean;
            var rr, c: integer;
                S: TSymbol;
            begin
            FindSymbol:= FALSE;
            for rr:= r1 to r2 do
              for c:= c1 to c2 do begin
                Line^.GetSymbol (rr, c, S);
                if (S.Ch=Sym.Ch) and (S.FontNum=Sym.FontNum) then begin
                  rFound:= rr; cFound:= c;
                  FindSymbol:= TRUE;
                  exit;
                  end;
                end;
            end;

{  ᥢ䨪    }
function    TSubLine.FindPsgraph (Ch: char; c,r1,r2: integer): integer;
            var r: integer;
                Sym: TSymbol;
                Font: PFont;
            begin
            FindPsgraph:= 0;
            for r:= r1 to r2 do begin
              Line^.GetSymbol (r,c,Sym);
              Font:= Fonts^.ThisTextFonts[Sym.FontNum];
              if (Sym.Ch=Ch) and (Font<>nil) and Font^.isDraw then begin
                FindPsgraph:= r; exit;
                end;
              end;
            end;

{     אַ㣮쭮  ப }
function    TSubLine.FindBase (var R: TRect): integer;
            var rr,c: integer;
                Sym: TSymbol;
            begin
            FindBase:= 0;
            for c:= R.c1 to R.c2 do
              for rr:= R.r2 downto R.r1 do
                if Line^.GetSymbol (rr,c,Sym) and not Sym.isBlank then begin
                  FindBase:= rr; exit;
                  end;
            end;

{ ஢ ப }
procedure   TSubLine.Substring (r0s, c1s, c2s: integer; var Res: String);
            var c: integer;
                Sym: TSymbol;
            begin
            Res[0]:= chr(c2s-c1s+1);
            for c:= c1s to c2s do begin
              Line^.GetSymbol (r0s,c,Sym);
              if Sym.FontNum=0 then Sym.Ch:=' ';
              Res[c-c1s+1]:= Sym.Ch;
              end;
            end;

{ ப  ஢ ⥪⮢ ப ? }
function    TSubLine.isJustLine: boolean;
            var Sym: TSymbol;
                isLJust, isRJust: boolean;
            begin
            Sym.Ch:= ssJust; Sym.FontNum:= 0;
            isRJust:= FindSymbol (Sym,r0,r0,Rect.c1,Rect.c1+3);
            isLJust:= FindSymbol (Sym,r0,r0,Rect.c2-3,Rect.c2);
            if isLJust or isRJust then begin
              if isMath then MakeModeChange (FALSE);
              if (nItem>0) then begin
                PutStr ('\end{enumerate}'); nItem:=0;
                end;
              Inc (nGroups);
              PutStr ('\centerline{');
              isSubLine:= TRUE;
              end;
            isJustLine:= isLJust or isRJust;
            end;

{    뤥  }
function    TSubLine.FindReference (var r,c1,c2: integer; var RefStr: String): boolean;
            var rr: integer;
                Buf: String;
            begin
            for rr:= Rect.r1 to Rect.r2 do begin {饬   }
              Substring (rr, RefBegin, RefEnd, Buf);
              c1:= length(Buf);
              c2:= 0;
              while (c1>0) and (Buf[c1]<>OpenRef) do begin
                if Buf[c1]=CloseRef then c2:= c1;
                Dec (c1);
                end;
              if (0<c1) and (c1<c2) then begin
                {᫨  }
                RefStr:= System.copy (Buf, c1+1, c2-c1-1);
                c1:= c1+RefBegin-1;
                c2:= c2+RefBegin-1;
                r:= rr;
                FindReference:= TRUE;
                exit;
                end;
              end;
            RefStr:='';
            FindReference:= FALSE;
            end;

{   אַ㣮쭨 ஡ }
procedure   TSubLine.FillBlanks (r1,r2,c1,c2: integer);
            var r,c: integer;
                Sym: TSymbol;
            begin
            Sym.Ch:= ' '; Sym.FontNum:= 1;
            for r:= r1 to r2 do
              for c:= c1 to c2 do
                Line^.PutSymbol (r,c,Sym);
            end;

{ ப  뤥 ⥬᪮ ப ? }
function    TSubLine.isMathLine: boolean;
            var r, c, nT, nM: integer;
                rRef, c1Ref, c2Ref, L: integer;
                isRef, isMat: boolean;
                Sym: TSymbol;
                Font: PFont;
                RefStr, Buf: String;
            begin
            nT:=0; nM:=0;
            for r:= Rect.r1 to Rect.r2 do
              for c:= Rect.c1 to Rect.c2 do
                if (Line^.GetSymbol(r,c,Sym)) and not Sym.isBlank then begin
                  Font:= Fonts^.ThisTextFonts [Sym.FontNum];
                  isMat:= Font^.isMath or Font^.isDraw;
                  if Sym.ChSeq<>nil then begin
                    Buf:= Sym.ChSeq^; L:= length(Buf);
                    isMat:= isMat or ((L>2) and (
                      (Buf[1]='$') and (Buf[L]='$') or
                      (Buf[1]='@') and (Buf[L]='@') ));
                    end;
                  if isMat then Inc(nM) else Inc(nT);
                  end;
            isRef:= FindReference (rRef,c1Ref,c2Ref,RefStr);
            if (((nT+nM<4)and(nM>0)) or ((nM+nT<20)and(nM>1)) or (nT<nM))
              and (isEmptyCol(MathCol)
              or (isRef and (c1Ref<=MathCol) and (MathCol<=c2Ref) ))
            then begin
              isMathLine:= TRUE;
              isReference:= isRef;
              if isMath then MakeModeChange (FALSE);
              if isRef then FillBlanks (rRef,rRef,c1Ref,c2Ref);
              TrunLR (RefStr);
              if RefStr<>'' then
                PutStr ('\begin{equation} \label{eqn'+RefStr+'}')
              else begin
                if isProlongMath then
                  PutStr ('\\')
                else
                  PutStr ('\[');
                end;
              isDisplayMath:= TRUE; isMath:= TRUE;
              end
            else isMathLine:= FALSE;
            end;

{ ப 稭   ? }
procedure   TSubLine.MakeLineBegin (var c: integer);
            var Sym: TSymbol;
                isTab, isItem: boolean;
                i: integer;
                Buf, sNum: String;
            begin
            c:= Rect.c1;
            {while Line^.GetSymbol (r0,c,Sym) and Sym.isBlank do Inc(c);}
            SkipEmpty (c);
            if isDisplayMath or isSubSubLine or isSubLine then exit;
            Substring (r0, Rect.c1, Rect.c1+2*TabuPos+5, Buf);
            isTab:= (c>=TabuPos);
            sNum:= Str(nItem+1);
            isItem:= (pos(sNum+'. ',Buf)=1) or (pos(sNum+') ',Buf)=1);
            if isMathLine then
            else if isJustLine then
            else if isItem then begin
              if isMath then MakeModeChange (FALSE);
              if nItem=0 then PutStr ('\begin{enumerate}');
              PutStr ('\item');
              Inc (nItem);
              Inc (c,length(sNum)+2);
              end
            else if isTab then begin
              if isMath then MakeModeChange (FALSE);
              if (nItem>0) then begin
                PutStr ('\end{enumerate}'); nItem:=0;
                end
              else PutStr ('');
              end;
            end;

{  楫 ப }
procedure   TSubLine.BeginLine;
            var Sym: TSymbol;
                R: TRect;
                isLJust, isRJust: boolean;
            begin
            Clear;
            (*
            if not isMathLine then  { 뤥 㫠 ? }
            if not isJustLine then  { ஢ ⥪ ? }
            ; {  ⮣  ᠬ 冷 ப}
            *)
            end;

{  ப: 㤠 㦭 ७, 뢠 㯯 }
procedure   TSubLine.FinishLine;
            var i: integer;
                isHyp: boolean;
            begin
            { ७ }
            TrunBlanks;
            isHyp:= pos(Chars^[Size],'-')>0;
            if isMath and isHyp and (Chars^[Size-1]='$') then begin
              Back(2); isMath:= FALSE;
              end else
            if not isMath and isHyp and (Chars^[Size-1]<>' ')
              then Back(1)
              else PutChar (' ');
            { 㯯 }
            if (nGroups>0) and isMath then
              MakeModeChange (FALSE);
            for i:= 1 to nGroups do begin
              TrunBlanks; PutStr ('}');
              CurrFontComm:= @MainFont;
              end;
            { 뤥 ⥬᪠  }
            if isDisplayMath then begin
              if isReference
                then PutStr ('\end{equation}')
                else PutStr ('\]');
              isMath:= FALSE;
              end;
            isProlongMath:= isDisplayMath and not isReference;
            end;

{*************************************************************************}
CONST { LineStatus constants }
      lsNormal=0;
      lsHeader=1;
      lsFooter=2;
      lsFootnote=3;
      lsSeparator=4;

{  ப ࠩ୮ ⥪. ப   ப }
constructor TLine.Init;
            begin
            TArray.Init (0, sizeof(PRow), 20);
            isMath:= FALSE;
            isProlongMath:= FALSE;
            nItem:= 0; nBraces:= 0;
            CurrFontNum:= 1;
            CurrFontComm:= nil;
            Status:= lsNormal;
            yScreen:=0;
            end;

destructor  TLine.Done;
            begin
            Clear; TArray.Done;
            end;

{ 頥 ப, 㭨⮦  ப }
procedure   TLine.Clear;
            var r: integer;
                row: PRow;
            begin
            for r:= 1 to Size do begin
              Get (r,row); Dispose (row,Done);
              end;
            Resize(0);
            yScreen:=0;
            end;

{ 頥 <ᨬ,>  <ப,> }
function    TLine.GetSymbol (r,c: integer; var Sym: TSymbol): boolean;
            var row: PRow;
            begin
            Sym.Ch:= ' '; Sym.FontNum:= 1;
            GetSymbol:= Get(r,row) and row^.Get(c,Sym);
            end;

{   ப <ᨬ,>  <ப,> }
procedure   TLine.PutSymbol (r,c: integer; var Sym: TSymbol);
            var row: PRow;
            begin
            if Get(r,row) then row^.Put(c,Sym);
            end;

{    ப   ப }
function    TLine.AddRow: PRow;
            var row: PRow;
            begin
            InsElems (Size+1, 1);
            new (row, Init);
            Put (Size, row);
            AddRow:= row;
            end;

{   ᨬ   ᫥ ப }
procedure   TLine.AddSymbol (var Sym: TSymbol);
            var row: PRow;
            begin
            if Get (Size, row) then begin
              row^.InsElems (row^.Size+1, 1);
              row^.Put (row^.Size, Sym);
              end;
            end;

{   ப, ⮫쪮  ⠭  室 ⥪ }
procedure   TLine.AddString (Buf: String; var Fonts: TFonts);
            var i,fk: integer;
                Sym,S: TSymbol;
                row: PRow;
            begin
            Sym.FontNum:= CurrFontNum;
            row:= AddRow; i:= 0;
            while (i<length(Buf)) do begin
              Inc(i);
              if Buf[i]='\' then begin
                Inc(i);
                fk:= Fonts.FontNumber (Buf[i]);
                if fk>0 then Sym.FontNum:= fk
                else if pos(Buf[i],'\ ')>0 then begin { \\  \஡ }
                  Sym.Ch:=Buf[i]; AddSymbol(Sym);
                  end
                else if Buf[i]='F' then begin { ᭮᪠ }
                  S.FontNum:= 0; S.Ch:= ssFoot;
                  AddSymbol(S);
                  end
                else if pos(Buf[i],'^')>0 then begin { ࠢ }
                  S.FontNum:= 0; S.Ch:= ssJust;
                  AddSymbol(S);
                  end
                else if Buf[i]='[' then begin { ⠡(᫥ ஡) }
                  S.FontNum:= 0; S.Ch:= ssTab;
                  AddSymbol(S);
                  end
                else if Buf[i]='+' then {  ப }
                  row^.Status:= rsPlus
                else if Buf[i]='-' then {  ப }
                  row^.Status:= rsMinus
                else; {  \/  ..   }
                end
              else if Buf[i]='' then { ⪨ ࠧ ࠭ }
              else begin
                Sym.Ch:=Buf[i]; AddSymbol(Sym);
                end;
              end;
            CurrFontNum:= Sym.FontNum;
            end;

{ 믮 ᨬ ४஢   ᨬ }
procedure   TLine.ReplaceChars (var Fonts: TFonts);
            var r,c: integer;
                row: PRow;
                Sym: TSymbol;
                Skip: boolean;
            begin
            Skip:= FALSE;
            for r:= 1 to Size do begin
              Get (r,row); c:= 1;
              while row^.Get (c,Sym) do
                with Fonts.ThisTextFonts[Sym.FontNum]^ do begin
                  if not Skip then begin
                    Sym.ChSeq:= GetCharSeq (Sym.Ch);
                    Sym.Ch:= GetCharCode (Sym.Ch);
                    end;
                  row^.Put (c,Sym);
                  Skip:= (Sym.FontNum=0) and (Sym.Ch=ssFoot);
                  Inc(c);
                  end;
              end;
            end;

{ 頥   ப }
function    TLine.MainRow: integer;
            var r: integer;
                row: PRow;
            begin
            MainRow:= 0;
            for r:= 1 to Size do
              if Get (r,row) and (row^.Status=rsMain) then begin
                MainRow:= r; exit;
                end;
            end;

{ 頥  ப }
function    TLine.LineLength: integer;
            var r, Max: integer;
                row: PRow;
            begin
            LineLength:=0; Max:=0;
            for r:= 1 to Size do
              if Get (r,row) and (row^.Size>Max) then begin
                Max:= row^.Size; LineLength:= Max;
                end;
            end;

function    TLine.isEmptyRow (r: integer; Fonts: PFonts): boolean;
            var c: integer;
                row: PRow;
                Sym: TSymbol;
                Font: PFont;
            begin
            isEmptyRow:= TRUE;
            if Get (r,row) then
              for c:= 1 to row^.Size do begin
                GetSymbol (r,c,Sym);
                Font:= Fonts^.ThisTextFonts[Sym.FontNum];
                if not (Sym.isBlank or Font^.isDraw) then begin
                  isEmptyRow:= FALSE; exit;
                  end;
                end;
            end;

function    TLine.isEmptyCol (c: integer; Fonts: PFonts): boolean;
            var r: integer;
                Sym: TSymbol;
                Font: PFont;
            begin
            isEmptyCol:= TRUE;
            for r:= 1 to Size do begin
                GetSymbol (r,c,Sym);
                Font:= Fonts^.ThisTextFonts[Sym.FontNum];
                if not (Sym.isBlank or Font^.isDraw) then begin
                  isEmptyCol:= FALSE; exit;
                  end;
                end;
            end;

{ ᫨ ப 宦  ⠡, । ᯥ樠쭠 ࠡ⪠ }
function    TLine.MakeTable (Fonts: PFonts; var Out: TOutputStream): boolean;
            var r,c, nCols, nRows: integer;
                isSpace, isEmpty: boolean;
                TabRows, TabCols: TArray;
                Sub: TSubLine;
                Rect: TRect;
            begin
            MakeTable:= FALSE;
            TabRows.Init (0, sizeof(integer), 100);
            isSpace:= TRUE;
            for r:= 1 to Size do begin
              isEmpty:= isEmptyRow(r,Fonts);
              if (isSpace xor isEmpty) then TabRows.Add(r);
              isSpace:= isEmpty;
              end;
            r:=Size+1; if (TabRows.Size mod 2=1) then TabRows.Add(r);

            if (TabRows.Size>2) and (UserReply(' ⠡? y/n ')='y')
            then begin
              MakeTable:= TRUE;
              TabCols.Init (0, sizeof(integer), 100);
              isSpace:= TRUE;
              for c:= 1 to LineLength do begin
                isEmpty:= isEmptyCol(c,Fonts);
                if (isSpace xor isEmpty) then TabCols.Add(c);
                isSpace:= isEmpty;
                end;
              c:=LineLength+1;
              if (TabCols.Size mod 2=1) then TabCols.Add(c);

              nCols:= TabCols.Size div 2;
              nRows:= TabRows.Size div 2;
              Out.PutStr ('\begin{tabular}{');
              for c:= 1 to nCols do Out.PutChar ('l');
              Out.PutStr ('}');
              for r:= 1 to nRows do begin
                for c:= 1 to nCols do begin
                  TabRows.Get (2*r-1,Rect.r1);
                  TabRows.Get (2*r,  Rect.r2); Dec(Rect.r2);
                  TabCols.Get (2*c-1,Rect.c1);
                  TabCols.Get (2*c,  Rect.c2); Dec(Rect.c2);
                  Sub.Init (Rect, Rect.r1, @Self, Fonts);
                  Sub.r0:= Sub.FindBase(Rect);
                  Sub.isSubLine:= TRUE;
                  Sub.Make;
                  Sub.MakeModeChange (FALSE);
                  Out.PutBuf (Sub);
                  Sub.Done;
                  if c<nCols then Out.PutStr (' & ');
                  end;
                Out.PutStr ('\\');
                end;
              Out.PutStr ('\end{tabular}');
              TabCols.Done;
              end;
            TabRows.Done;
            end;

{  楤 ᯮ  ࠭樨 ப }
procedure   TLine.Make (Fonts: PFonts; var Out: TOutputStream);
            var Sub: TSubLine;
                R: TRect;
            begin
            if MakeTable (Fonts, Out) then exit;
            R.r1:=1; R.r2:=Size;
            R.c1:=1; R.c2:=LineLength;
            Sub.Init (R, MainRow, @Self, Fonts);
            Sub.nItem:= nItem;
            Sub.nBraces:= nBraces;
            Sub.isMath:= isMath;
            Sub.isProlongMath:= isProlongMath;
            Sub.CurrFontComm:= CurrFontComm;
            Sub.BeginLine;
            Sub.Make;
            Sub.FinishLine;
            Out.PutBuf (Sub);
            nItem:= Sub.nItem;
            nBraces:= Sub.nBraces;
            isProlongMath:= Sub.isProlongMath;
            isMath:= Sub.isMath;
            CurrFontComm:= Sub.CurrFontComm;
            Sub.Done;
            end;

{ 뢠 ப  ⥪⮢ ०,   梥⮬ }
procedure   TLine.ShowInTextMode;
            var r,c: integer;
                row: PRow;
                Sym: TSymbol;
            begin
            for r:= 1 to Size do begin
              Get (r, row); c:= 1;
              TextAttr:= $07; writeln;
              write (r:2,'.');
              while row^.Get (c, Sym) do begin
                TextAttr:= FontsTextAttr [Sym.FontNum];
                write (Sym.Ch);
                Inc(c);
                end;
              end;
            TextAttr:= $07; writeln;
            end;

{ 뢠 ப  ᪮ ०,   梥⮬ }
procedure   TLine.ShowInGraphMode;
            var r,c,xScreen,x,ym: integer;
                row: PRow;
                Sym: TSymbol;
                Buf: String[5];
            const
                RowCol: array [TRowStatus] of word = (7,15,7);
            begin
            GraphBegin;
            Inc (yScreen,16);
            SetColor (8);
            ym:= yScreen+8*Size+8;
            Rectangle (xScreen0-2, yScreen+6, xScreen0+8*LineLength+2, ym);
            for c:= 1 to LineLength do begin
              x:= xScreen0+(c-1)*8-1;
              if (c=1) or (c mod 10 =0) then begin
                Line (x, yScreen+6, x, ym+18);
                OutTextXY (x+2,ym+10, Str(c));
                end
              else Line (x,ym,x,ym+4);
              end;
            for r:= 1 to Size do begin
              Get (r, row); c:= 1;
              Inc (yScreen,8); xScreen:= xScreen0;
              SetColor (RowCol[row^.Status]);
              System.Str (r:2,Buf);
              OutTextXY (0,yScreen,Buf);
              while row^.Get (c, Sym) do begin
                SetColor (FontColor[Sym.FontNum]);
                if Sym.Ch=' ' then Sym.Ch:='';
                OutTextXY (xScreen,yScreen,Sym.Ch);
                Inc(c); Inc(xScreen,8);
                end;
              end;
            end;

{ 뢠 ப  ᪮ ०,   룫廊  ࠩ }
procedure   TLine.ShowAsChiWriter (var Fonts: TFonts);
            var r,c,xScreen: integer;
                Sym: TSymbol;
                row: PRow;
                Font: PFont;
            begin
            GraphBegin;
            ClearDevice;
            SetFillStyle (SolidFill, coBgrd);
            Bar (0, yScreen, GetMaxX, yScreen+(Size+2)*RowDist);
            for r:= 1 to Size do begin
              Get (r,row); c:=1; xScreen:= xScreen0;
              Inc (yScreen,RowDist);
              while row^.Get (c,Sym) do begin
                Font:= Fonts.ThisTextFonts [Sym.FontNum];
                if (Font<>nil) then begin
                  if (Font^.SftFont=nil) then Font^.LoadSftFont;
                  Font^.SftFont^.ShowChar (xScreen, yScreen, Sym.Ch);
                  Inc (xScreen, Font^.SftFont^.Width);
                  end;
                Inc(c);
                end;
              end;
            end;

{ 뢮 ப  ஬  }
procedure   TLine.Output (var Out: TOutputStream);
            var r,c: integer;
                row: PRow;
                Sym: TSymbol;
                isLine: boolean;
            begin
            for r:= 1 to Size do begin
              Get (r, row); c:= 1;
              isLine:= FALSE;
              while row^.Get (c, Sym) do begin
                write (Out.F, Sym.Ch); Inc(c);
                isLine:= isLine or not Sym.isBlank;
                end;
              if isLine then writeln (Out.F);
              end;
            end;

{*************************************************************************}
{  ८ࠧ⥫ ChiWriter -> TeX }
constructor TConverter.Init (InpFileName: String);
            var OutFileName: String;
                p: integer;
            begin
            assign (Inp, InpFileName); reset (Inp);
            p:= pos('.',InpFileName);
            if p>0
              then OutFileName:= copy (InpFileName,1,p)+'TeX'
              else OutFileName:= InpFileName+'.TeX';
            Out.Init (OutFileName, nViewLines, TeXLineLim);
            Line.Init;
            Fonts.Init;
            BigSigns.Init (0, sizeof(TSign), 50);
            WideSigns.Init (0, sizeof(TSign), 50);
            Accents.Init (0, sizeof(TSign), 50);
            JobMode:= jmTexWork;
            end;

destructor  TConverter.Done;
            begin
            close (Inp);
            Out.Done;
            Line.Done;
            Fonts.Done;
            BigSigns.Done;
            WideSigns.Done;
            Accents.Done;
            end;

{ 믮  ८ࠧ }
procedure   TConverter.Make;
            var isLine, isBreak: boolean;
                Status: byte;
                Buf, OldBuf: String;
            begin
            isLine:= FALSE; isBreak:= FALSE;
            Buf:='';
            while not EOF(Inp) and not isBreak do begin
              OldBuf:= Buf;
              Readln (Inp, Buf);
              if isLine and LineEnds (OldBuf,Buf) then begin
                if Status=lsNormal then
                  isBreak:= (MakeLine=mrBreak);
                isLine:= FALSE;
                end;
              if not isLine and LineBegins (Buf, Status) then begin
                isLine:= TRUE;
                Line.Clear;
                Line.AddString (Buf, Fonts);
                end
              else if isLine then
                Line.AddString (Buf, Fonts);
              end;
            if isLine and not isBreak then MakeLine;
            if Line.nItem>0 then
              Out.PutStr ('\end{enumerate}');
            if not isBreak and (Line.CurrFontComm^<>MainFont) then
              Out.PutStr ('}');
            Out.PutStr (EndText);
            Out.SendToFile;
            end;

{    ப   ப? }
function    TConverter.LineBegins (var Buf: String; var Status: byte): boolean;
            var n,i,o,fk: integer;
                f: PFont;
            begin
            Status:= lsNormal;
            LineBegins:= TRUE;
            if Buf[1]<>'\' then {}
            else if Buf[2]='U' then begin
              fk:= Fonts.FontNumber (Buf[3]);
              f:= Fonts.FindFont (copy(Buf,4,255));
              if (f<>nil) then
                Fonts.ThisTextFonts[fk]:= f;
              LineBegins:= FALSE;
              end
            else if Buf[2]='H' then Status:= lsHeader
            else if Buf[2]='F' then Status:= lsFooter
            else if Buf[2]='S' then Status:= lsSeparator
            else if Buf[2]='N' then Status:= lsFootNote
            else if (pos(Buf[2],'p=')>0) or (pos('\1cw',Buf)=1) then
              LineBegins:= FALSE;
            end;

{   ப   ப? }
function    TConverter.LineEnds (var OldBuf, Buf: String): boolean;
            begin
            {
            LineEnds:= (pos('\H',OldBuf)<>1) and
                       (pos('\F',OldBuf)<>1) and
                       (pos('\+',OldBuf)<>1) and
                       (pos('\-',Buf)<>1);
            }
            LineEnds:= ( (OldBuf[1]<>'\') or (pos(OldBuf[2],'HFS+')=0) )
                       and (pos('\-',Buf)<>1);
            end;

{ 믮 ८ࠧ  ப }
function    TConverter.MakeLine: TMakeResult;
            begin
            Line.yScreen:= 20;
            case JobMode of
              jmTexDebug: begin
                if Line.Status=lsNormal then begin
                  Line.ShowAsChiWriter (Fonts);
                  Line.ReplaceChars (Fonts);
                  Line.ShowInGraphMode;
                  Fonts.Show (575, Line.yScreen+50);
                  Line.Make (@Fonts, Out);
                  Out.Show (0, Line.yScreen+50);
                  WaitKey;
                  end;
                MakeLine:= mrNormal;
                if LastKey=27 then MakeLine:= mrBreak;
                end;
              jmTexWork: begin
                if Line.Status=lsNormal then begin
                  Line.ShowAsChiWriter (Fonts);
                  Line.ReplaceChars (Fonts);
                  Line.Make (@Fonts, Out);
                  end;
                MakeLine:= mrNormal;
                if KeyPressed and (WaitKey=27) then MakeLine:= mrBreak;
                end;
              jmAsciiDebug: begin
                if Line.Status=lsNormal then begin
                  Line.ShowAsChiWriter (Fonts);
                  Line.ReplaceChars (Fonts);
                  Line.ShowInGraphMode;
                  Fonts.Show (570, Line.yScreen+50);
                  WaitKey;
                  end;
                MakeLine:= mrNormal;
                if LastKey=27 then MakeLine:= mrBreak;
                end;
              jmAsciiWork: begin
                if Line.Status=lsNormal then begin
                  Line.ReplaceChars (Fonts);
                  Line.Output (Out);
                  end;
                MakeLine:= mrNormal;
                end;
              end;
            end;

{ 㦠 ini-䠩, ᮤঠ騩 騥 ࠬ  ४஢ ⮢ }
procedure   TConverter.LoadIni (IniFileName: String);
            var Ini: TIniFile;
                N,V: String;
                Font: PFont;
                isPreamble: boolean;
                KindOfLine: integer;

            {  ᨬ    ॢ }
            procedure AddSign (var Arr: TArray; Mask: word);
                var Sign: TSign;
                begin
                Arr.InsElems (Arr.Size+1, 1);
                Sign.Init (V, Font, Mask);
                Arr.Put (Arr.Size, Sign);
                end;

            begin
            isPreamble:= FALSE;
            Ini.Init (IniFileName);
            repeat
              KindOfLine:= Ini.NextLine;
              if isPreamble and (KindOfLine<>stTopic) then begin
                Out.PutStr (Ini.Buf); Out.PutEOL;
                end
              else case KindOfLine of
                stRemark, stCommon: {ignore};
                stTopic: begin
                  isPreamble:= (Ini.TopicName='Preamble');
                  if pos('Preamble',Ini.TopicName)=0 then begin
                    New (Font, Init(@Fonts));
                    Font^.Name:= Ini.TopicName;
                    Fonts.AddFont (Font);
                    end;
                  end;
                stValue: begin
                  N:= Ini.VarName; V:= Ini.VarValue;
                  if N='FontDir' then FontDir:= V else
                  if N='FontExt' then FontExt:= V else
                  if N='EndText' then EndText:= V else
                  if N='JobMode' then JobMode:= round(val(V)) else
                  if N='RowDist' then RowDist:= round(val(V)) else
                  if N='ForeCol' then coText:= round(val(V)) else
                  if N='BackCol' then coBgrd:= round(val(V)) else
                  if N='MathCol' then MathCol:= round(val(V)) else
                  if N='LineLim' then TeXLineLim:= round(val(V)) else
                  if N='SeeLins' then Out.nLines:= round(val(V)) else
                  if N='TabuPos' then TabuPos:= round(val(V)) else
                  if N='BegRefr' then RefBegin:= round(val(V)) else
                  if N='EndRefr' then RefEnd:= round(val(V)) else
                  if Font<>nil then with Font^ do begin
                    if (N='AK') or (N='BK') then SetCharCodes (N,V) else
                    if length(N)=1 then SetCharSeq (N[1], V) else
                    if N='base' then CopyCharSeq (Fonts^.FindFont(V)) else
                    if N='math' then isMath:= (V='1') else
                    if N='draw' then isDraw:= (V='1') else
                    if N='brac' then AddSign (BigSigns, 1) else
                    if N='sign' then AddSign (BigSigns, 0) else
                    if N='wide' then AddSign (WideSigns, 0) else
                    if N='acce' then AddSign (Accents, 0) else
                    if N='comm' then Command:= V;
                    end;
                  end;
                end;
            until KindOfLine=stEOF;
            Ini.Done;
            with Fonts do ThisTextFonts[0]:= FindFont ('SYSTEM');
            end;
end.