#include <stdio.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "CalcuLib.h"

//  ,        
void compile (int ExprID, const char* expression) {
	FC_String str;
	// 
	FC_Compile (ExprID, expression);
	//   
	FC_GetSource (ExprID, &str);
	printf ("SOURCE %s\n", str);
	//     
	if (FC_GetLastMessage (&str)==0)
		printf ("COMPILATION ERROR: %s\n", str);
	else
		printf ("COMPILATION OK\n");
	//  
	FC_GetPseudocodeListing (ExprID, &str);
	printf ("PSEUDOCODE\n%s", str);
}

//   ,        
void calculate (int ExprID) {
	FC_String varname, str;
	int error;
	//  
	int VarMax = FC_GetTableSize (ExprID);
	printf ("-----\nTABLE CONTAINS %d VARIABLES\n", VarMax);
	for (int VarID=0; VarID<VarMax; VarID++) {
		FC_GetVarName (ExprID, VarID, &varname);
		error = FC_GetVarString (ExprID, VarID, &str);
		printf ("%s = %s\n", varname, error+7?str:"[]");
	}
	//  
	error = FC_CalcString (ExprID, &str);
	printf ("RESULT = %s\n", error+6?str:"[]");
	//     
	if (FC_GetLastMessage (&str)==0)
		printf ("EXECUTION ERROR: %s\n", str);
	else
		printf ("EXECUTION OK\n");
}

//  --      
void compile_short (int ExprID, const char* expression) {
	FC_String str;
	// 
	FC_Compile (ExprID, expression);
	//   
	FC_GetSource (ExprID, &str);
	printf ("%s", str);
	//     
	if (FC_GetLastMessage (&str)==0)
		printf (" (COMP.ERR: %s)", str);
	printf ("\n");
}

//  --      
void calculate_short (int ExprID) {
	FC_String varname, str;
	int error;
	//  
	error = FC_CalcString (ExprID, &str);
	printf ("\t=%s", error+6?str:"[]");
	//     
	if (FC_GetLastMessage (&str)==0)
		printf (" (CALC.ERR %s)", str);
	//  
	int VarMax = FC_GetTableSize (ExprID);
	if (VarMax>0) printf (" (");
	for (int VarID=0; VarID<VarMax; VarID++) {
		FC_GetVarName (ExprID, VarID, &varname);
		error = FC_GetVarString (ExprID, VarID, &str);
		if (VarID>0) printf ("; ");
		printf ("%s=%s", varname, error+7?str:"[]");
	}
	if (VarMax>0) printf (")");
	printf ("\n");
}

//   ,    
void test1 (int verbose) {
	int count = 0;
	int ExprID; 
	char bufferline [2002];
	while (!feof(stdin)) {
		//  ,   
		if (fgets (bufferline, 2000, stdin)==0) break;
		count++;
		char* b = bufferline + strlen(bufferline) - 1;
		while (b>=bufferline && (*b==' ' || *b=='\t' || *b=='\n')) *b-- = '\0';
		b = bufferline;
		while (*b && (*b==' ' || *b=='\t' || *b=='\n')) b++;
		//     
		if (*b=='\0' || *b=='#' || *b=='!')
			continue;
		//        
		if (*b==';') {
			char* name = strtok (b+1,"=");
			while (name) {
				char* value = strtok (0,";");
				if (name && value)
					FC_SetVarString (ExprID, FC_GetVarID (ExprID, name), value);
				name = strtok (0,"=");
			}
			if (verbose)
				calculate (ExprID);
			else
				calculate_short (ExprID);
			continue;
		}
		//    
		ExprID = count % 10;
		if (verbose) {
			printf ("----- Expression at line %d -------------------------------------\n", count);
			compile (ExprID, b);
			calculate (ExprID);
		}
		else {
			printf ("Line%d\t", count);
			compile_short (ExprID, b);
			calculate_short (ExprID);
		}
	}
}

//        ++
void test2 () {
	const int MAX_COUNT = 1000000;
	const double PI = 3.14159265;
	int count, ExprID = 1; 
	clock_t begin;
	//   
	FC_String str;
	FC_Compile (ExprID, "(PI-a/1000) / (PI+a/1000)");
	int aID = FC_GetVarID (ExprID, "a");
	double a, sec, Result;
	//   
	begin = clock ();
	for (count=0; count<MAX_COUNT; count++) {
		FC_SetVarNumber (ExprID, aID, count);
		FC_CalcNumber (ExprID, &Result);
	}
	sec = double(clock()-begin)/CLOCKS_PER_SEC;
	printf ("Time spend %.3f -- compiled expression\n", sec);
	//   
	begin = clock ();
	for (count=0; count<MAX_COUNT; count++) {
		a = double(count);
		Result = (PI-a/1000) / (PI+a/1000);
	}
	sec = double(clock()-begin)/CLOCKS_PER_SEC;
	printf ("Time spend %.3f -- builtin expression \n", sec);
}

//  
void main (int argc, char *argv[]) {
	FC_Start ();
	int verbose = (argc>1 && strcmp(argv[1],"-s")==0) ? 0 : 1;
	test1 (verbose);
	//test2 ();
	FC_Finish ();
	FC_String str;
	FC_GetMemoryReport (&str);
	printf ("\n=================================================\n%s\n", str);
	getchar ();
}
