//	Free Calculator Library   (c) copyright by K.Vorontsov,  january 2000

typedef const char* FC_String;

//  
int FC_Start ();   //   
int FC_Finish ();   //  
int FC_GetFreeExprID ();   //    
int FC_GetLastMessage (FC_String* Message);   //     
int FC_GetMemoryReport (FC_String* Buffer);  //      ,    FC_Finish

//  
int FC_Compile (int ExprID, FC_String Source);   //  
int FC_GetSource (int ExprID, FC_String* Source);   //    
int FC_GetPseudocodeListing (int ExprID, FC_String* Listing);   //     

//   
int FC_CalcNumber (int ExprID, double* Result);   //   ,    
int FC_CalcInteger (int ExprID, int* Result);   //   ,    
int FC_CalcString (int ExprID, FC_String* Result);   //   ,    

//    
int FC_GetTableSize (int ExprID);   //    
int FC_GetVarID (int ExprID, FC_String VarName);   //        
int FC_GetVarName (int ExprID, int VarID, FC_String* VarName);   //        

//     
int FC_SetVarNumber (int ExprID, int VarID, double Value);   //    
int FC_SetVarInteger (int ExprID, int VarID, int Value);   //    
int FC_SetVarString (int ExprID, int VarID, FC_String Value);   //    

int FC_GetVarNumber (int ExprID, int VarID, double *Value);   //   ,    
int FC_GetVarInteger (int ExprID, int VarID, int *Value);   //   ,    
int FC_GetVarString (int ExprID, int VarID, FC_String *Value);   //   ,    

/*
	      

	      .
  FC_Compile    ,   
         . 
       empty. 
    FC_SetVarNumber, FC_SetVarInteger
 FC_SetVarString.     FC_CalcNumber, 
FC_CalcInteger  FC_CalcString.

	1.   

	        
 FC_Start,       FC_Finish.
 FC_Finish     FC_GetMemoryReport, 
     .

	2.  
	
	      .
      ExprID.
 FC_Compile   ,    
ExprID    ,   Source.   
     ,    
FC_GetFreeExprID     .

	3.    

	    .   ,  :
		(-1)     FC_Start;
		(-2)    ExprID;
		(-3)    VarID;
		(-4)      .
     . 
 FC_GetFreeExprID  FC_GetVarID  ,
    .

	4.   : ,   

	      ,     
     int, real  string.   FC_CalcXxx, 
   ,    FC_SetVarXxx
 FC_GetVarXxx,     ,  
  :      int, real  string .

	5.        

	       FC_String:
(1)           
 FC_String StrArgument,       
 ,        .
(2)            
  FC_String* StrArgument,       
 ,        .

	  
	
	1.  

	    :
		 bool (0  1);
		 int (4-  );
		 real (8-    );
		 string (  );
		- datetime ( ,   1  1970);
		 error.
     ,  
     (. ).
 bool  datetime   int    .
     bool   
  TRUE,   0 -  FALSE.
 error        .

	2. 

	      ,  
     , :
		0b0000.1000  -  8
		0b0100.1010  -  74
		0xFFFF  -  65535
		0xC20E  -  49678
       
  ,   .

	    -   
,    . : 2.345e+8, 345E-8, 20.345;

	     .

	 -      :
		datetime ("1997-08-21 11:15:20")
   ,      "-"  "/".

	    empty.
     empty   0, 
     -  "empty".

	3.  
	
	      ,   
   :
		empty
		FALSE = int (0);
		TRUE = int (1);
		PI = 3.1415926535897931;
		MINUTE = long (60);
		HOUR = long (60 * 60);
		DAY = long (60 * 60 * 24);
		WEEK = long (60 * 60 * 24 * 7);

	4.    

	       Basic, Pascal  . 
     .
     :    
   0<=x<1      
  0<=x and x<1,      .
    .

	5.  

	     (  ):
		  or
		  and
		  not
		6   <=, >=, <>, <, >, = 
		   &
		  +   -
		  *,  /     %
		    ^

	6.  

	        , 
        . 
     ,  sqrt, sin, exp. 
   ,  log, rand, setbit. 
    ,  min, max, if, steps, xor. 
,   ,    : now(), rand().

	    ,   .
     ,   
    .   
    []. ,    
 (    ),     {}. 
  any   .

	7.  .

  
	bool bool(any) -  any   
	int int(any) -  any   
	real real(any) -  any    
	string string(any) -  any   
	datetime datetime(any) -  any   -
	time datetime(any) -  any  datetime   
	date datetime(any) -  any  datetime   

  
	IsEmpty bool(any) - TRUE   any   
	IsNumber bool(any) - TRUE   any 
	IsTime bool(any) - TRUE   any 
	
     
	abs real(real) -   ()  real
	sign int(real) -   real,   -1, 0, 1
	sqrt real(real) -    real
	sin real(real) -   real
	cos real(real) -   real
	tan real(real) -   real
	exp real(real) -   real
	log real(real1,[real2]) -   real1   real2,   real2 
	rand real([real1],[real2]) -     [real1,real2), [0,real1)  [0,1)
	round real(real) -    
	upround real(real) -      ()
	dnround real(real) -      ()
	
     
	max real({real}) -  
	min real({real}) -  
	xor bool({bool}) -    
	
    
	Bit bool(int1,int2) - int2-     int1
	SetBit int(int1,[int2],[bool]) -  int1-   int2 (0  )  bool (1  )
	OrBit int({int}) -  
	AndBit int({int}) -  
	XorBit int({int}) -   
	NotBit int(int) -  
	
      
	now datetime() -  -
	year int(datetime) -    datetime
	month int(datetime) -    datetime, =1, =2, ...
	day int(datetime) -    ,   1
	hours int(datetime) -      datetime
	minutes int(datetime) -    datetime
	seconds int(datetime) -    datetime
	WeekDay int(datetime) -   , =0, =1,...
	YearDay int(datetime) -    
	
    
	len int(string) -  
	pos string(string1,string2) -   string2   string1, (-1)   ,   0
	left string(string,int) -     int,   0
	right string(string,int) -    int,   0
	mid string(string,int1,int2) -       int1  int2,   0

   
	if any({bool1,any1},anyN) -  , : 
		any1,  bool1=TRUE,
		any2,  bool2=TRUE,    ...
		anyN,      FALSE.
	steps int(real1, {real}) -  , :
		0,  real1<real2,
		1,  real2<=real1<real3,
		2,  real3<=real1<real4,    ...

*/

