unit CalculatorForm;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls;

type
	TForm1 = class(TForm)
		Edit1: TEdit;
		Memo1: TMemo;
    Label1: TLabel;
    Label2: TLabel;
		procedure FormCreate(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure FormResize(Sender: TObject);
	private
		ExprID: integer;
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	Form1: TForm1;

implementation
uses CalcuLib;

{$R *.DFM}
{$X+}
{$H+}

procedure TForm1.FormCreate(Sender: TObject);
begin
	ExprID:= FC_GetFreeExprID();
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
var
	result, errmsg: PChar;
begin
	if ord(Key)=13 then begin
		FC_Compile (ExprID, PChar(Edit1.Text));
		if FC_GetLastMessage (errmsg) = 0 then
			Memo1.Lines.Append ('COMPILATION ERROR in "' + Edit1.Text + '": ' + errmsg)
		else begin
			FC_CalcString (ExprID, result);
			if FC_GetLastMessage (errmsg) = 0 then
				Memo1.Lines.Append ('RUNTIME ERROR in "' + Edit1.Text + '": ' + errmsg)
			else
				Memo1.Lines.Append (Edit1.Text + ' = ' + result);
		end;
	end;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
	Edit1.Width:= ClientWidth - 2*Edit1.Left;
	Memo1.Width:= ClientWidth - 2*Memo1.Left;
    Memo1.Height:= ClientHeight - Memo1.Top - Edit1.Left;
end;

end.
